/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.WMSLayersPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WMSLayerManager {
    private static final String[] servers = new String[]{"http://neowms.sci.gsfc.nasa.gov/wms/wms", "http://wms.jpl.nasa.gov/wms.cgi"};

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind WMS Layers", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private final Dimension wmsPanelSize = new Dimension(400, 600);
        private JTabbedPane tabbedPane = new JTabbedPane();
        private int previousTabIndex;

        public AppFrame() {
            this.tabbedPane.add(new JPanel());
            this.tabbedPane.setTitleAt(0, "+");
            this.tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.tabbedPane.getSelectedIndex() != 0) {
                        AppFrame.this.previousTabIndex = AppFrame.this.tabbedPane.getSelectedIndex();
                        return;
                    }
                    String string = JOptionPane.showInputDialog("Enter wms server URL");
                    if (string == null || string.length() < 1) {
                        AppFrame.this.tabbedPane.setSelectedIndex(AppFrame.this.previousTabIndex);
                        return;
                    }
                    if (AppFrame.this.addTab(AppFrame.this.tabbedPane.getTabCount(), string.trim()) != null) {
                        AppFrame.this.tabbedPane.setSelectedIndex(AppFrame.this.tabbedPane.getTabCount() - 1);
                    }
                }
            });
            for (int i = 0; i < servers.length; ++i) {
                this.addTab(i + 1, servers[i]);
            }
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() > 0 ? 1 : 0);
            this.previousTabIndex = this.tabbedPane.getSelectedIndex();
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().add(this.tabbedPane);
            jFrame.pack();
            jFrame.setDefaultCloseOperation(3);
            jFrame.setVisible(true);
        }

        private WMSLayersPanel addTab(int n, String string) {
            try {
                WMSLayersPanel wMSLayersPanel = new WMSLayersPanel(this.getWwd(), string, this.wmsPanelSize);
                this.tabbedPane.add((Component)wMSLayersPanel, "Center");
                String string2 = wMSLayersPanel.getServerDisplayString();
                this.tabbedPane.setTitleAt(n, string2 != null && string2.length() > 0 ? string2 : string);
                wMSLayersPanel.addPropertyChangeListener("LayersPanelUpdated", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        AppFrame.this.getLayerPanel().update(AppFrame.this.getWwd());
                    }
                });
                return wMSLayersPanel;
            }
            catch (URISyntaxException uRISyntaxException) {
                JOptionPane.showMessageDialog(null, "Server URL is invalid", "Invalid Server URL", 0);
                this.tabbedPane.setSelectedIndex(this.previousTabIndex);
                return null;
            }
        }
    }
}

