/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.SurfaceImage;

public class SurfaceImages
extends ApplicationTemplate {
    private static final String WWJ_SPLASH_PATH = "images/400x230-splash-nww.png";
    private static final String GEORSS_ICON_PATH = "images/georss.png";
    private static final String NASA_ICON_PATH = "images/32x32-icon-nasa.png";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Surface Images", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            try {
                SurfaceImage surfaceImage = new SurfaceImage(SurfaceImages.WWJ_SPLASH_PATH, Sector.fromDegrees(35.0, 45.0, -115.0, -95.0));
                SurfaceImage surfaceImage2 = new SurfaceImage(SurfaceImages.GEORSS_ICON_PATH, Sector.fromDegrees(25.0, 33.0, -120.0, -110.0));
                SurfaceImage surfaceImage3 = new SurfaceImage(SurfaceImages.NASA_ICON_PATH, Sector.fromDegrees(25.0, 35.0, -100.0, -90.0));
                surfaceImage.setOpacity(0.7);
                RenderableLayer renderableLayer = new RenderableLayer();
                renderableLayer.setName("Surface Images");
                renderableLayer.addRenderable(surfaceImage);
                renderableLayer.addRenderable(surfaceImage2);
                renderableLayer.addRenderable(surfaceImage3);
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
                this.getLayerPanel().update(this.getWwd());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

