/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.render.SurfaceImage;

public class RemoteSurfaceImage
extends ApplicationTemplate {
    private static final String MARS_MOC_COLOR_URL = "http://worldwind25.arc.nasa.gov/baseImages/mocC256_base.jpg";
    private static final String JUPITER_BASE_URL = "http://worldwind25.arc.nasa.gov/baseImages/jupiter_2048x1024.jpg";
    private static final String EARTH_NIGHT_LIGHTS_URL = "http://veimages.gsfc.nasa.gov/1438/earth_lights_lrg.jpg";
    private static final String NRL_BM_DAY_NIGHT_STITCHED = "http://www.nrlmry.navy.mil/archdat/global/stitched/day_night_bm/20080425.1800.multisat.visir.bckgr.Global_Global_bm.DAYNGT.jpg";
    private static final String GLOBAL_CLOUDS = "http://worldwind25.arc.nasa.gov/GlobalClouds/GlobalClouds.aspx";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Remote Surface Image", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            LayerList layerList = this.getWwd().getModel().getLayers();
            try {
                layerList.clear();
                layerList.add(new StarsLayer());
                layerList.add(new SkyGradientLayer());
                RenderableLayer renderableLayer = new RenderableLayer();
                String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.BMNGOneImagePath");
                SurfaceImage surfaceImage = new SurfaceImage(string, Sector.FULL_SPHERE);
                renderableLayer.setName("Local Surface Image");
                renderableLayer.addRenderable(surfaceImage);
                renderableLayer.setPickEnabled(false);
                layerList.add(renderableLayer);
                renderableLayer = new RenderableLayer();
                surfaceImage = new SurfaceImage(RemoteSurfaceImage.EARTH_NIGHT_LIGHTS_URL, Sector.FULL_SPHERE, renderableLayer);
                renderableLayer.setName("Remote Surface Image");
                renderableLayer.addRenderable(surfaceImage);
                renderableLayer.setPickEnabled(false);
                renderableLayer.setOpacity(0.5);
                layerList.add(renderableLayer);
                this.getLayerPanel().update(this.getWwd());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

