/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.formats.gpx.GpxReader;
import gov.nasa.worldwind.layers.TrackPipesLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.tracks.Track;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PipeTracks
extends ApplicationTemplate {
    private static final String TRACK_FILE1 = "demodata/PipeTrackTest.gpx";
    private static final String TRACK_FILE2 = "demodata/PipeTracks2.gpx";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Pipe Tracks", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() throws IOException, ParserConfigurationException, SAXException {
            super(true, true, false);
            TrackPipesLayer trackPipesLayer = this.buildTracksLayer(PipeTracks.TRACK_FILE1);
            trackPipesLayer.setPipeMaterial(Material.WHITE);
            trackPipesLayer.setJunctionMaterial(Material.RED);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), trackPipesLayer);
            trackPipesLayer = this.buildTracksLayer(PipeTracks.TRACK_FILE2);
            trackPipesLayer.setPipeMaterial(Material.GREEN);
            trackPipesLayer.setJunctionMaterial(Material.YELLOW);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), trackPipesLayer);
        }

        private TrackPipesLayer buildTracksLayer(String string) throws IOException, SAXException, ParserConfigurationException {
            GpxReader gpxReader = new GpxReader();
            gpxReader.readFile(string);
            List<Track> list = gpxReader.getTracks();
            return new TrackPipesLayer(list);
        }
    }
}

