/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class BasicDragger
implements SelectListener {
    private final WorldWindow wwd;
    private boolean dragging = false;

    public BasicDragger(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.dragging = false;
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            DragSelectEvent dragSelectEvent = (DragSelectEvent)selectEvent;
            Object object = dragSelectEvent.getTopObject();
            if (object == null) {
                return;
            }
            if (!(object instanceof Movable)) {
                return;
            }
            Movable movable = (Movable)object;
            View view = this.wwd.getView();
            Globe globe = this.wwd.getModel().getGlobe();
            Position position = movable.getReferencePosition();
            Vec4 vec4 = globe.computePointFromPosition(position);
            Vec4 vec42 = view.project(vec4);
            int n = dragSelectEvent.getPickPoint().x - dragSelectEvent.getPreviousPickPoint().x;
            double d = vec42.x + (double)n;
            int n2 = dragSelectEvent.getPickPoint().y - dragSelectEvent.getPreviousPickPoint().y;
            double d2 = (double)selectEvent.getMouseEvent().getComponent().getSize().height - vec42.y + (double)n2 - 1.0;
            Line line = view.computeRayFromScreenPoint(d, d2);
            Intersection[] intersectionArray = globe.intersect(line, position.getElevation());
            if (intersectionArray != null) {
                Position position2 = globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
                movable.moveTo(position2);
            }
            this.dragging = true;
        }
    }
}

