/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.AnaglyphSceneController;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Angle;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnaglyphStereo
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.SceneControllerClassName", AnaglyphSceneController.class.getName());
        ApplicationTemplate.start("World Wind Anaglyph Stereo", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private String displayMode = ((AnaglyphSceneController)this.getWwd().getSceneController()).getDisplayMode();
        private Angle focusAngle = ((AnaglyphSceneController)this.getWwd().getSceneController()).getFocusAngle();
        private JSlider focusAngleSlider;

        public AppFrame() {
            super(true, true, false);
            this.getLayerPanel().add((Component)this.makeStereoPanel(), "South");
        }

        private JPanel makeStereoPanel() {
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 0, 0));
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton("Mono");
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.displayMode = AnaglyphSceneController.DISPLAY_MODE_MONO;
                    AppFrame.this.update();
                }
            });
            jRadioButton.setSelected(!this.displayMode.equals(AnaglyphSceneController.DISPLAY_MODE_STEREO));
            buttonGroup.add(jRadioButton);
            jPanel2.add(jRadioButton);
            JRadioButton jRadioButton2 = new JRadioButton("Stereo");
            jRadioButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.displayMode = AnaglyphSceneController.DISPLAY_MODE_STEREO;
                    AppFrame.this.update();
                }
            });
            jRadioButton2.setSelected(this.displayMode.equals(AnaglyphSceneController.DISPLAY_MODE_STEREO));
            buttonGroup.add(jRadioButton2);
            jPanel2.add(jRadioButton2);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
            JSlider jSlider = new JSlider(0, 0, 50, (int)(this.focusAngle.degrees * 10.0));
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(1);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setToolTipText("Focus angle 1/10 degrees");
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        AppFrame.this.focusAngle = Angle.fromDegrees((double)jSlider.getValue() / 10.0);
                        AppFrame.this.update();
                    }
                }
            });
            jPanel3.add(jSlider);
            jSlider.setEnabled(this.displayMode.equals(AnaglyphSceneController.DISPLAY_MODE_STEREO));
            this.focusAngleSlider = jSlider;
            JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 0, 0));
            JLabel jLabel = new JLabel("Tip: pitch view for stereo effect.");
            jLabel.setHorizontalAlignment(0);
            jPanel4.add(jLabel);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("View")));
            jPanel.setToolTipText("Stereo controls");
            return jPanel;
        }

        private void update() {
            AnaglyphSceneController anaglyphSceneController = (AnaglyphSceneController)this.getWwd().getSceneController();
            anaglyphSceneController.setDisplayMode(this.displayMode);
            anaglyphSceneController.setFocusAngle(this.focusAngle);
            this.focusAngleSlider.setEnabled(this.displayMode.equals(AnaglyphSceneController.DISPLAY_MODE_STEREO));
            this.getWwd().redraw();
        }
    }
}

