/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.event;

import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public class SelectEvent
extends EventObject {
    public static final String LEFT_CLICK = "gov.nasa.worldwind.SelectEvent.LeftClick";
    public static final String LEFT_DOUBLE_CLICK = "gov.nasa.worldwind.SelectEvent.LeftDoubleClick";
    public static final String RIGHT_CLICK = "gov.nasa.worldwind.SelectEvent.RightClick";
    public static final String LEFT_PRESS = "gov.nasa.worldwind.SelectEvent.LeftPress";
    public static final String RIGHT_PRESS = "gov.nasa.worldwind.SelectEvent.RightPress";
    public static final String HOVER = "gov.nasa.worldwind.SelectEvent.Hover";
    public static final String ROLLOVER = "gov.nasa.worldwind.SelectEvent.Rollover";
    public static final String DRAG = "gov.nasa.worldwind.SelectEvent.Drag";
    public static final String DRAG_END = "gov.nasa.worldwind.SelectEvent.DragEnd";
    private final String eventAction;
    private final Point pickPoint;
    private final MouseEvent mouseEvent;
    private final PickedObjectList pickedObjects;

    public SelectEvent(Object object, String string, MouseEvent mouseEvent, PickedObjectList pickedObjectList) {
        super(object);
        this.eventAction = string;
        this.pickPoint = mouseEvent != null ? mouseEvent.getPoint() : null;
        this.mouseEvent = mouseEvent;
        this.pickedObjects = pickedObjectList;
    }

    public SelectEvent(Object object, String string, Point point, PickedObjectList pickedObjectList) {
        super(object);
        this.eventAction = string;
        this.pickPoint = point;
        this.mouseEvent = null;
        this.pickedObjects = pickedObjectList;
    }

    public String getEventAction() {
        return this.eventAction != null ? this.eventAction : "gov.nasa.worldwind.SelectEvent.UnknownEventAction";
    }

    public Point getPickPoint() {
        return this.pickPoint;
    }

    public MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    public boolean hasObjects() {
        return this.pickedObjects != null && this.pickedObjects.size() > 0;
    }

    public PickedObjectList getObjects() {
        return this.pickedObjects;
    }

    public PickedObject getTopPickedObject() {
        return this.hasObjects() ? this.pickedObjects.getTopPickedObject() : null;
    }

    public Object getTopObject() {
        PickedObject pickedObject = this.getTopPickedObject();
        return pickedObject != null ? pickedObject.getObject() : null;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.eventAction != null ? this.eventAction : Logging.getMessage("generic.Unknown");
    }
}

