/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.cache.AbstractFileCache;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class BasicDataFileCache
extends AbstractFileCache {
    public BasicDataFileCache() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.DataFileCacheConfigurationFileName");
        if (string == null) {
            String string2 = Logging.getMessage("FileCache.NoConfiguration");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        InputStream inputStream = null;
        File file = new File(string);
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string3 = Logging.getMessage("FileCache.LocalConfigFileNotFound", string);
                Logging.logger().finest(string3);
            }
        }
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            String string4 = Logging.getMessage("FileCache.ConfigurationNotFound", string);
            Logging.logger().severe(string4);
            throw new IllegalStateException(string4);
        }
        this.initialize(inputStream);
    }
}

