/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.util.Logging;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyPollTimer
implements KeyListener {
    private Timer timer;
    private TimerTask timerTask;
    private final int period;
    private final ActionListener listener;
    private ArrayList<Integer> keys = new ArrayList();
    private Stack<Integer> keyStack = new Stack();
    private int modifiers;

    public KeyPollTimer(int n, Collection<Integer> collection, ActionListener actionListener) {
        if (n < 0) {
            String string = Logging.getMessage("Awt.KeyPollTimer.PeriodLessThanZero");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (collection == null) {
            String string = Logging.getMessage("nullValue.CollectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.timer = new Timer();
        this.period = n;
        this.listener = actionListener;
        this.keys.addAll(collection);
        WorldWind.addPropertyChangeListener("gov.nasa.worldwind.ShutDown", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                KeyPollTimer.this.timer.cancel();
                KeyPollTimer.this.timer = null;
            }
        });
    }

    public synchronized boolean isRunning() {
        return this.timerTask != null;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return;
        }
        if (this.onKeyEvent(keyEvent) && this.timerTask == null) {
            this.start();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return;
        }
        if (this.onKeyEvent(keyEvent) && this.timerTask != null && this.keyStack.empty()) {
            this.stop();
        }
    }

    private synchronized boolean onKeyEvent(KeyEvent keyEvent) {
        this.modifiers = keyEvent.getModifiersEx();
        Integer n = keyEvent.getKeyCode();
        if (this.keys.contains(n)) {
            if (this.keyStack.contains(n)) {
                this.keyStack.remove(n);
            }
            if (keyEvent.getID() == 401) {
                this.keyStack.push(n);
            }
            return true;
        }
        return false;
    }

    public synchronized void start() {
        if (this.timerTask == null) {
            this.timerTask = new TimerTask(){

                public void run() {
                    long l = System.currentTimeMillis();
                    if (l - this.scheduledExecutionTime() >= (long)(2 * KeyPollTimer.this.period)) {
                        return;
                    }
                    KeyPollTimer.this.updateAndNotify(KeyPollTimer.this.listener);
                }
            };
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.schedule(this.timerTask, 0L, (long)this.period);
        }
    }

    public synchronized void stop() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    private synchronized void updateAndNotify(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        if (this.keyStack.empty()) {
            return;
        }
        actionListener.actionPerformed(new ActionEvent(this.keyStack.peek(), 0, null, this.modifiers));
    }
}

