/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.ScalebarLayer;
import gov.nasa.worldwind.layers.TerrainProfileLayer;
import gov.nasa.worldwind.util.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class WWPanel
extends JPanel {
    private WorldWindowGLCanvas wwd;
    private StatusBar statusBar;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "SAR2.ElevationUnit") {
                WWPanel.this.updateElevationUnit(propertyChangeEvent.getNewValue());
            }
        }
    };

    public WWPanel() {
        super(new BorderLayout());
        this.wwd = new WorldWindowGLCanvas();
        this.wwd.setPreferredSize(new Dimension(800, 800));
        Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
        this.wwd.setModel(model);
        this.wwd.addPropertyChangeListener(this.propertyChangeListener);
        this.add((Component)this.wwd, "Center");
        this.statusBar = new StatusBar();
        this.add((Component)this.statusBar, "Last");
        this.statusBar.setEventSource(this.wwd);
    }

    public WorldWindowGLCanvas getWwd() {
        return this.wwd;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void updateElevationUnit(Object object) {
        for (Layer layer : this.wwd.getModel().getLayers()) {
            if (layer instanceof ScalebarLayer) {
                if ("Imperial".equals(object)) {
                    ((ScalebarLayer)layer).setUnit("gov.nasa.worldwind.ScalebarLayer.Imperial");
                    continue;
                }
                ((ScalebarLayer)layer).setUnit("gov.nasa.worldwind.ScalebarLayer.Metric");
                continue;
            }
            if (!(layer instanceof TerrainProfileLayer)) continue;
            if ("Imperial".equals(object)) {
                ((TerrainProfileLayer)layer).setUnit("gov.nasa.worldwind.TerrainProfileLayer.Imperial");
                continue;
            }
            ((TerrainProfileLayer)layer).setUnit("gov.nasa.worldwind.TerrainProfileLayer.Metric");
        }
        if ("Imperial".equals(object)) {
            this.statusBar.setElevationUnit("gov.nasa.worldwind.StatusBar.Imperial");
        } else {
            this.statusBar.setElevationUnit("gov.nasa.worldwind.StatusBar.Metric");
        }
    }
}

