/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.applications.sar.AnalysisPanel;
import gov.nasa.worldwind.applications.sar.ControlPanel;
import gov.nasa.worldwind.applications.sar.HelpFrame;
import gov.nasa.worldwind.applications.sar.LayerMenu;
import gov.nasa.worldwind.applications.sar.OSXAdapter;
import gov.nasa.worldwind.applications.sar.SARAboutDialog;
import gov.nasa.worldwind.applications.sar.SARAnnotation;
import gov.nasa.worldwind.applications.sar.SARAnnotationSupport;
import gov.nasa.worldwind.applications.sar.SARTrack;
import gov.nasa.worldwind.applications.sar.SaveTrackDialog;
import gov.nasa.worldwind.applications.sar.TrackController;
import gov.nasa.worldwind.applications.sar.TracksPanel;
import gov.nasa.worldwind.applications.sar.WWPanel;
import gov.nasa.worldwind.layers.Earth.USGSDigitalOrtho;
import gov.nasa.worldwind.layers.Earth.USGSTopographicMaps;
import gov.nasa.worldwind.layers.Earth.USGSUrbanAreaOrtho;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.WWIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class SAR2
extends JFrame {
    private TrackController trackController;
    private SARAnnotationSupport annotationSupport;
    private WorldWindow wwd;
    private Timer redrawTimer;
    private static final int REDRAW_TIMER_DELAY = 1000;
    private ControlPanel controlPanel;
    private WWPanel wwPanel;
    private LayerMenu layerMenu;
    private JCheckBoxMenuItem feetMenuItem;
    private JCheckBoxMenuItem metersMenuItem;
    private HelpFrame helpFrame;
    private JFileChooser openFileChooser;
    private SaveTrackDialog saveTrackDialog;
    private static final int OK = 0;
    private static final int CANCELLED = 2;
    private static final int ERROR = 4;
    private String elevationUnit;
    public static final String ELEVATION_UNIT = "SAR2.ElevationUnit";
    public static final String UNIT_IMPERIAL = "Imperial";
    public static final String UNIT_METRIC = "Metric";
    private static final double METER_TO_FEET = 3.280839895;

    public SAR2() {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.initComponents();
        this.setTitle("World Wind Search and Rescue Prototype (Version 4.3 released 4/9/08)");
        this.wwd = this.wwPanel.getWwd();
        for (Layer layer : this.wwd.getModel().getLayers()) {
            if (layer instanceof USGSDigitalOrtho) {
                layer.setOpacity(0.5);
                layer.setEnabled(false);
                continue;
            }
            if (layer instanceof USGSTopographicMaps) {
                layer.setEnabled(false);
                layer.setOpacity(0.5);
                continue;
            }
            if (!(layer instanceof USGSUrbanAreaOrtho)) continue;
            layer.setEnabled(false);
        }
        this.getAnalysisPanel().setWwd(this.wwd);
        this.trackController = new TrackController();
        this.trackController.setWwd(this.wwd);
        this.trackController.setTracksPanel(this.getTracksPanel());
        this.trackController.setAnalysisPanel(this.getAnalysisPanel());
        this.layerMenu.setWwd(this.wwd);
        this.annotationSupport = new SARAnnotationSupport();
        this.annotationSupport.setWwd(this.wwd);
        this.setElevationUnit(UNIT_IMPERIAL);
        this.redrawTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.wwd.redraw();
            }
        });
        this.redrawTimer.start();
    }

    public static void centerWindowInDesktop(Window window) {
        if (window != null) {
            int n = Toolkit.getDefaultToolkit().getScreenSize().width;
            int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(window.getGraphicsConfiguration());
            int n3 = n - insets.left - insets.right;
            int n4 = n2 - insets.bottom - insets.top;
            int n5 = window.getSize().width;
            int n6 = window.getSize().height;
            if (n5 > n3) {
                n5 = Math.min(n5, n3);
            }
            if (n6 > n4) {
                n6 = Math.min(n6, n4);
            }
            window.setPreferredSize(new Dimension(n5, n6));
            window.pack();
            window.setLocation((n3 - n5) / 2 + insets.left, (n4 - n6) / 2 + insets.top);
        }
    }

    public static double metersToFeet(double d) {
        return d * 3.280839895;
    }

    public static double feetToMeters(double d) {
        return d / 3.280839895;
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        String string2 = this.elevationUnit;
        this.elevationUnit = string;
        this.elevationUnitChanged(string2, this.elevationUnit);
    }

    private void elevationUnitChanged(String string, String string2) {
        if (UNIT_IMPERIAL.equals(string2)) {
            this.feetMenuItem.setSelected(true);
        } else if (UNIT_METRIC.equals(string2)) {
            this.metersMenuItem.setSelected(true);
        }
        this.getTracksPanel().setElevationUnit(string2);
        this.wwd.setValue(ELEVATION_UNIT, string2);
        this.wwd.firePropertyChange(ELEVATION_UNIT, string, string2);
        this.wwd.redraw();
    }

    public SARTrack getCurrentTrack() {
        return this.getTracksPanel().getCurrentTrack();
    }

    public TracksPanel getTracksPanel() {
        return this.controlPanel.getTracksPanel();
    }

    public AnalysisPanel getAnalysisPanel() {
        return this.controlPanel.getAnalysisPanel1();
    }

    private void newTrack(String string) {
        Object object = JOptionPane.showInputDialog(this, "Enter a new track name", "Add New Track", 3, null, null, string);
        if (object == null) {
            return;
        }
        string = object.toString();
        SARTrack sARTrack = new SARTrack(string);
        this.trackController.addTrack(sARTrack);
        sARTrack.clearDirtyBit();
    }

    private void newTrackFromFile(String string, String string2) {
        Object object;
        if (string == null && (object = this.showOpenDialog("Choose a track file")) != null) {
            string = ((File)object).getPath();
        }
        if (string == null) {
            return;
        }
        object = null;
        try {
            object = SARTrack.fromFile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return;
        }
        if (string2 != null) {
            ((SARTrack)object).setName(string2);
        }
        this.trackController.addTrack((SARTrack)object);
        try {
            String string3 = this.getAnnotationsPath(string);
            this.annotationSupport.readAnnotations(string3, (SARTrack)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((SARTrack)object).clearDirtyBit();
    }

    private File showOpenDialog(String string) {
        if (this.openFileChooser == null) {
            this.openFileChooser = new JFileChooser();
        }
        if (string == null) {
            string = "Open Track";
        }
        this.openFileChooser.setDialogTitle(string);
        this.openFileChooser.setMultiSelectionEnabled(false);
        int n = this.openFileChooser.showOpenDialog(this);
        return n == 0 ? this.openFileChooser.getSelectedFile() : null;
    }

    private void newTrackFromURL(String string, String string2) {
        Object object;
        if (string == null && (object = JOptionPane.showInputDialog(this, "Enter a track URL", "Add New Track", 3, null, null, null)) != null) {
            string = object.toString();
        }
        if (string == null) {
            return;
        }
        object = SAR2.makeURL(string);
        if (object == null) {
            return;
        }
        SARTrack sARTrack = null;
        try {
            ByteBuffer byteBuffer = WWIO.readURLContentToBuffer((URL)object);
            File file = WWIO.saveBufferToTempFile(byteBuffer, ".xml");
            sARTrack = SARTrack.fromFile(file.getPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (sARTrack == null) {
            return;
        }
        if (string2 == null) {
            string2 = string;
        }
        sARTrack.setFile(null);
        sARTrack.setName(string2);
        this.trackController.addTrack(sARTrack);
        sARTrack.markDirty();
    }

    private static URL makeURL(String string) {
        URL uRL = null;
        try {
            if (string != null) {
                uRL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    private int removeTrack(SARTrack sARTrack, boolean bl) {
        if (sARTrack == null) {
            return 0;
        }
        int n = 0;
        if (sARTrack.isDirty() || bl) {
            int n2 = SaveTrackDialog.showSaveChangesPrompt(this, null, null, sARTrack);
            if (n2 == 0) {
                n = this.saveTrack(sARTrack, true);
            } else if (n2 == 2) {
                n = 2;
            }
        }
        if (n != 0) {
            return n;
        }
        try {
            sARTrack.firePropertyChange("TrackController.TrackRemoved", null, sARTrack);
            this.trackController.refreshCurrentTrack();
            this.annotationSupport.removeAnnotationsForTrack(sARTrack);
            this.wwd.redraw();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 4;
        }
        return 0;
    }

    private int removeAllTracks(boolean bl) {
        int n = 0;
        for (SARTrack sARTrack : this.getTracksPanel().getAllTracks()) {
            if (((n |= this.removeTrack(sARTrack, bl)) & 2) == 0) continue;
            return n;
        }
        return n;
    }

    private int saveTrack(SARTrack sARTrack, boolean bl) {
        return this.saveTrack(sARTrack, null, 0, true, bl);
    }

    private int saveTrack(SARTrack sARTrack, File file, int n, boolean bl, boolean bl2) {
        if (sARTrack == null) {
            return 0;
        }
        if (file == null) {
            file = sARTrack.getFile();
        }
        if (n == 0) {
            n = sARTrack.getFormat();
        }
        if (file == null || bl2) {
            int n2 = this.showSaveDialog(sARTrack);
            if (n2 == 1) {
                return 2;
            }
            if (n2 == -1) {
                return 4;
            }
            file = this.saveTrackDialog.getSelectedFile();
            n = this.saveTrackDialog.getFileFormat();
            bl = this.saveTrackDialog.isSaveAnnotations();
        }
        try {
            long l = file.exists() ? file.lastModified() : 0L;
            SARTrack.toFile(sARTrack, file.getPath(), n);
            if (bl) {
                String string = this.getAnnotationsPath(file.getPath());
                this.annotationSupport.writeAnnotations(string, sARTrack);
            }
            if (file.exists() && l <= file.lastModified()) {
                sARTrack.setFile(file);
                sARTrack.setFormat(n);
                sARTrack.setName(file.getName());
                sARTrack.clearDirtyBit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 4;
        }
        return 0;
    }

    private int showSaveDialog(SARTrack sARTrack) {
        if (this.saveTrackDialog == null) {
            this.saveTrackDialog = new SaveTrackDialog();
        }
        this.saveTrackDialog.setDialogTitle(sARTrack);
        this.saveTrackDialog.setFileFormat(sARTrack);
        this.saveTrackDialog.setSelectedFile(sARTrack);
        return this.saveTrackDialog.showSaveDialog(this);
    }

    private SARAnnotation getCurrentAnnotation() {
        return this.annotationSupport.getCurrent();
    }

    private void newAnnotation() {
        this.newAnnotation(null, this.getCurrentTrack());
    }

    private void newAnnotation(String string, SARTrack sARTrack) {
        this.annotationSupport.addNew(string, sARTrack);
        this.wwd.redraw();
    }

    private void removeAnnotation(SARAnnotation sARAnnotation) {
        if (sARAnnotation != null) {
            this.annotationSupport.remove(sARAnnotation);
        }
        this.wwd.redraw();
    }

    private void setAnnotationsEnabled(boolean bl) {
        this.annotationSupport.setEnabled(bl);
        this.wwd.redraw();
    }

    private void showHelp() {
        try {
            if (this.helpFrame == null) {
                this.helpFrame = new HelpFrame();
            }
            this.helpFrame.setVisible(true);
        }
        catch (IOException iOException) {
            System.err.println("Unable to open Help window");
            iOException.printStackTrace();
        }
    }

    public void showAbout() {
        SARAboutDialog sARAboutDialog = new SARAboutDialog();
        sARAboutDialog.showDialog(this);
    }

    public boolean exit() {
        int n = this.removeAllTracks(false);
        if ((n & 2) != 0) {
            return false;
        }
        this.dispose();
        System.exit(0);
        return true;
    }

    private String getAnnotationsPath(String string) {
        return string != null ? string + ".sta" : null;
    }

    private void initComponents() {
        this.setTitle("World Wind Search and Rescue");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SAR2.this.exit();
            }

            public void windowClosed(WindowEvent windowEvent) {
                SAR2.this.exit();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.controlPanel = new ControlPanel();
        container.add((Component)this.controlPanel, "West");
        this.wwPanel = new WWPanel();
        this.wwPanel.setPreferredSize(new Dimension(1000, 800));
        container.add((Component)this.wwPanel, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        jMenu.setText("File");
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText("New Track...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrack(null);
            }
        });
        jMenu.add(jMenuItem);
        Serializable serializable = new JMenuItem();
        ((AbstractButton)serializable).setText("Open Track File...");
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromFile(null, null);
            }
        });
        jMenu.add((JMenuItem)serializable);
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText("Open Track URL...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromURL(null, null);
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setText("Close Track");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.removeTrack(SAR2.this.getCurrentTrack(), false);
            }
        });
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem();
        jMenuItem4.setText("Save Track");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.saveTrack(SAR2.this.getCurrentTrack(), true);
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem();
        jMenuItem5.setText("Save Track As...");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.saveTrack(SAR2.this.getCurrentTrack(), true);
            }
        });
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem();
        jMenuItem6.setText("PipeTrackTest.gpx");
        jMenuItem6.setActionCommand("http://worldwind.arc.nasa.gov/java/apps/SARApp/PipeTrackTest.xml");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromURL(actionEvent.getActionCommand(), null);
            }
        });
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem();
        jMenuItem7.setText("PipeTracks2.gpx");
        jMenuItem7.setActionCommand("http://worldwind.arc.nasa.gov/java/apps/SARApp/PipeTracks2.xml");
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromURL(actionEvent.getActionCommand(), null);
            }
        });
        jMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem();
        jMenuItem8.setText("PipeTracks3.gpx");
        jMenuItem8.setActionCommand("http://worldwind.arc.nasa.gov/java/apps/SARApp/PipeTracks3.xml");
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newTrackFromURL(actionEvent.getActionCommand(), null);
            }
        });
        jMenu.add(jMenuItem8);
        if (!Configuration.isMacOS()) {
            jMenu.addSeparator();
            JMenuItem jMenuItem9 = new JMenuItem();
            jMenuItem9.setText("Exit");
            jMenuItem9.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SAR2.this.exit();
                }
            });
            jMenu.add(jMenuItem9);
        } else {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("exit", null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        jMenuBar.add(jMenu);
        jMenuItem = new JMenu();
        jMenuItem.setText("Units");
        jMenuItem.setMnemonic('V');
        this.metersMenuItem = new JCheckBoxMenuItem();
        this.metersMenuItem.setText("Meters");
        this.metersMenuItem.setActionCommand(UNIT_METRIC);
        this.metersMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.setElevationUnit(actionEvent.getActionCommand());
            }
        });
        ((JMenu)jMenuItem).add(this.metersMenuItem);
        this.feetMenuItem = new JCheckBoxMenuItem();
        this.feetMenuItem.setText("Feet");
        this.feetMenuItem.setActionCommand(UNIT_IMPERIAL);
        this.feetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.setElevationUnit(actionEvent.getActionCommand());
            }
        });
        ((JMenu)jMenuItem).add(this.feetMenuItem);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.metersMenuItem);
        ((ButtonGroup)serializable).add(this.feetMenuItem);
        jMenuBar.add((JMenu)jMenuItem);
        serializable = new JMenu();
        ((AbstractButton)serializable).setText("Annotation");
        ((AbstractButton)serializable).setMnemonic('A');
        jMenuItem2 = new JMenuItem();
        jMenuItem2.setText("New Annotation...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.newAnnotation();
            }
        });
        ((JMenu)serializable).add(jMenuItem2);
        jMenuItem3 = new JMenuItem();
        jMenuItem3.setText("Remove Annotation");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.removeAnnotation(SAR2.this.getCurrentAnnotation());
            }
        });
        ((JMenu)serializable).add(jMenuItem3);
        jMenuItem4 = new JCheckBoxMenuItem();
        jMenuItem4.setText("Show Annotations");
        jMenuItem4.setSelected(true);
        jMenuItem4.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SAR2.this.setAnnotationsEnabled(itemEvent.getStateChange() == 1);
            }
        });
        ((JMenu)serializable).add(jMenuItem4);
        jMenuBar.add((JMenu)serializable);
        this.layerMenu = new LayerMenu();
        this.layerMenu.setMnemonic('L');
        jMenuBar.add(this.layerMenu);
        jMenuItem2 = new JMenu();
        jMenuItem2.setText("Help");
        jMenuItem2.setMnemonic('H');
        jMenuItem3 = new JMenuItem();
        jMenuItem3.setText("Search and Rescue Help");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAR2.this.showHelp();
            }
        });
        ((JMenu)jMenuItem2).add(jMenuItem3);
        if (!Configuration.isMacOS()) {
            jMenuItem4 = new JMenuItem();
            jMenuItem4.setText("About");
            jMenuItem4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SAR2.this.showAbout();
                }
            });
            ((JMenu)jMenuItem2).add(jMenuItem4);
        } else {
            try {
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAbout", null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        jMenuBar.add((JMenu)jMenuItem2);
        this.setJMenuBar(jMenuBar);
        this.pack();
        SAR2.centerWindowInDesktop(this);
    }
}

