/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.applications.sar.AppendPositionAction;
import gov.nasa.worldwind.applications.sar.DeletePositionsAction;
import gov.nasa.worldwind.applications.sar.InsertPositionAction;
import gov.nasa.worldwind.applications.sar.PositionTable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PositionsContextMenu
extends MouseAdapter {
    private final PositionTable positionTable;

    public PositionsContextMenu(PositionTable positionTable) {
        this.positionTable = positionTable;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        boolean bl = this.positionTable.getSarTrack().size() > 0 && this.positionTable.getSelectedRowCount() > 0;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new DeletePositionsAction(this.positionTable));
        jMenuItem.setEnabled(bl);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new AppendPositionAction(this.positionTable));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new InsertPositionAction(true, this.positionTable));
        jMenuItem.setEnabled(bl);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new InsertPositionAction(false, this.positionTable));
        jMenuItem.setEnabled(bl);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(this.positionTable, mouseEvent.getX(), mouseEvent.getY());
    }
}

