/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.util.Logging;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public class LicenseDialog {
    private final Object license;
    private String contentType;
    private Dimension preferredSize;
    private String title;
    public static final int ACCEPT_OPTION = 1;
    public static final int DECLINE_OPTION = 2;
    public static final int ERROR_OPTION = 3;

    public LicenseDialog(Object object) {
        if (object == null) {
            String string = "nullValue.licenseIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.license = object;
    }

    public final Object getLicense() {
        return this.license;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int showDialog(Component component) {
        int n;
        Object object = this.makeLicenseComponent();
        if (object != null) {
            n = LicenseDialog.showLicenseDialog(component, object, this.title);
        } else {
            String string = this.missingLicenseMessage();
            LicenseDialog.showMissingLicenseDialog(component, string, null);
            n = 3;
        }
        return n;
    }

    private static int showLicenseDialog(Component component, Object object, String string) {
        int n;
        try {
            if (object instanceof Component) {
                object = new JScrollPane((Component)object);
            }
            n = JOptionPane.showOptionDialog(component, object, string, 0, -1, null, new Object[]{"Accept", "Decline"}, "Accept");
        }
        catch (Exception exception) {
            String string2 = "Exception while displaying license dialog";
            Logging.logger().log(Level.SEVERE, string2, exception);
            return 3;
        }
        return n == 0 ? 1 : 2;
    }

    private static void showMissingLicenseDialog(Component component, String string, String string2) {
        try {
            JOptionPane.showOptionDialog(component, string, string2, 0, 0, null, new Object[]{"OK"}, "OK");
        }
        catch (Exception exception) {
            String string3 = "Exception while displaying missing license dialog";
            Logging.logger().log(Level.SEVERE, string3, exception);
        }
    }

    private String missingLicenseMessage() {
        return "License Agreement is missing.";
    }

    private Object makeLicenseComponent() {
        JTextComponent jTextComponent = null;
        try {
            if (this.license != null) {
                if (this.license instanceof URL) {
                    Logging.logger().fine("Fetching license (URL): " + this.license);
                    jTextComponent = new JEditorPane();
                    if (this.contentType != null) {
                        ((JEditorPane)jTextComponent).setContentType(this.contentType);
                    }
                    ((JEditorPane)jTextComponent).setPage((URL)this.license);
                } else if (this.license instanceof File) {
                    Logging.logger().fine("Fetching license (File): " + this.license);
                    URL uRL = ((File)this.license).toURL();
                    jTextComponent = new JEditorPane();
                    if (this.contentType != null) {
                        ((JEditorPane)jTextComponent).setContentType(this.contentType);
                    }
                    ((JEditorPane)jTextComponent).setPage(uRL);
                } else {
                    Logging.logger().fine("Fetching license (String): " + this.license.toString());
                    URL uRL = this.getClass().getResource(this.license.toString());
                    jTextComponent = new JEditorPane();
                    if (this.contentType != null) {
                        ((JEditorPane)jTextComponent).setContentType(this.contentType);
                    }
                    ((JEditorPane)jTextComponent).setPage(uRL);
                }
            }
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
                if (this.preferredSize != null) {
                    jTextComponent.setPreferredSize(this.preferredSize);
                }
            }
        }
        catch (Exception exception) {
            String string = "Exception while fetching license content";
            Logging.logger().log(Level.SEVERE, string, exception);
            jTextComponent = null;
        }
        return jTextComponent;
    }
}

