/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.applications.sar.PositionTable;
import gov.nasa.worldwind.applications.sar.SARTrack;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class DeletePositionsAction
extends AbstractAction {
    protected final PositionTable table;

    public DeletePositionsAction(PositionTable positionTable) {
        this.table = positionTable;
        int n = positionTable.getSelectedRowCount();
        if (n <= 1) {
            this.putValue("Name", "Delete Selected Position");
        } else {
            this.putValue("Name", "Delete Selected Positions");
        }
        this.putValue("LongDescription", "Remove Positions from Track");
        if (n == 0) {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SARTrack sARTrack = this.table.getSarTrack();
        if (sARTrack != null) {
            sARTrack.removePositions(this.table.getSelectedRows());
        }
    }
}

