/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.applications.sar.RayCastingSupport;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;

public class BasicDragger2
implements SelectListener {
    private final WorldWindow wwd;
    private boolean dragging = false;
    private Point dragRefCursorPoint;
    private Vec4 dragRefObjectPoint;
    private double dragRefAltitude;

    public BasicDragger2(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.dragging = false;
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            Object object;
            DragSelectEvent dragSelectEvent = (DragSelectEvent)selectEvent;
            Object object2 = dragSelectEvent.getTopObject();
            if (object2 == null) {
                return;
            }
            if (!(object2 instanceof Movable)) {
                return;
            }
            Movable movable = (Movable)object2;
            View view = this.wwd.getView();
            Globe globe = this.wwd.getModel().getGlobe();
            Position position = movable.getReferencePosition();
            Vec4 vec4 = null;
            if (position.getElevation() < globe.getMaxElevation()) {
                vec4 = this.wwd.getSceneController().getTerrain().getSurfacePoint(position);
            }
            if (vec4 == null) {
                vec4 = globe.computePointFromPosition(position);
            }
            if (!this.isDragging()) {
                this.dragRefObjectPoint = view.project(vec4);
                this.dragRefCursorPoint = dragSelectEvent.getPreviousPickPoint();
                this.dragRefAltitude = globe.computePositionFromPoint(vec4).getElevation();
            }
            int n = dragSelectEvent.getPickPoint().x - this.dragRefCursorPoint.x;
            int n2 = dragSelectEvent.getPickPoint().y - this.dragRefCursorPoint.y;
            double d = this.dragRefObjectPoint.x + (double)n;
            double d2 = (double)selectEvent.getMouseEvent().getComponent().getSize().height - this.dragRefObjectPoint.y + (double)n2 - 1.0;
            Line line = view.computeRayFromScreenPoint(d, d2);
            Position position2 = null;
            if (view.getEyePosition().getElevation() < globe.getMaxElevation() * 10.0) {
                position2 = RayCastingSupport.intersectRayWithTerrain(globe, line.getOrigin(), line.getDirection(), 200.0, 20.0);
            } else {
                object = globe.intersect(line, this.dragRefAltitude);
                if (object != null) {
                    position2 = globe.computePositionFromPoint(object[0].getIntersectionPoint());
                }
            }
            if (position2 != null) {
                object = new Position(position2.getLatLon(), movable.getReferencePosition().getElevation());
                movable.moveTo((Position)object);
            }
            this.dragging = true;
        }
    }
}

