/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.applications.sar.PositionTable;
import gov.nasa.worldwind.applications.sar.SARPosition;
import gov.nasa.worldwind.applications.sar.SARTrack;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class AppendPositionAction
extends AbstractAction {
    protected final PositionTable table;

    public AppendPositionAction(PositionTable positionTable) {
        this.table = positionTable;
        this.putValue("Name", "Append New Position to Track");
        this.putValue("LongDescription", "Add a new position to the end of the Track");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SARTrack sARTrack = this.table.getSarTrack();
        if (sARTrack == null) {
            return;
        }
        if (sARTrack.size() != 0) {
            sARTrack.appendPosition(sARTrack.get(sARTrack.size() - 1));
        } else {
            sARTrack.appendPosition(new SARPosition());
        }
        this.table.getSelectionModel().setSelectionInterval(sARTrack.size() - 1, sARTrack.size() - 1);
    }
}

