/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.applications.sar.PlaneModel;
import gov.nasa.worldwind.applications.sar.SARPosition;
import gov.nasa.worldwind.applications.sar.SARTrack;
import gov.nasa.worldwind.applications.sar.TerrainProfilePanel;
import gov.nasa.worldwind.applications.sar.TrackViewPanel;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CrosshairLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class AnalysisPanel
extends JPanel {
    private WorldWindow wwd;
    private SARTrack currentTrack;
    private TrackViewPanel trackViewPanel;
    private TerrainProfilePanel terrainProfilePanel;
    private CrosshairLayer crosshairLayer;
    private RenderableLayer planeModelLayer;
    private PlaneModel planeModel;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "TrackViewPanel.ViewChange") {
                AnalysisPanel.this.updateView(true);
            } else if (propertyChangeEvent.getPropertyName() == "TrackViewPanel.PositionChange") {
                AnalysisPanel.this.updateView(false);
            } else if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.avkey.ElevationModel" && AnalysisPanel.this.trackViewPanel.isExamineViewMode() && !AnalysisPanel.this.wwd.getView().hasStateIterator()) {
                AnalysisPanel.this.updateView(false);
            } else if (propertyChangeEvent.getPropertyName() == "SAR2.ElevationUnit") {
                AnalysisPanel.this.updateElevationUnit(propertyChangeEvent.getNewValue());
            }
            if ((propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.avkey.ViewObject" || propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.avkey.ViewQuiet") && AnalysisPanel.this.trackViewPanel.isFollowViewMode()) {
                AnalysisPanel.this.updateCrosshair();
            }
        }
    };

    public AnalysisPanel() {
        this.initComponents();
        this.planeModel = new PlaneModel(100.0, 100.0, Color.YELLOW);
        this.planeModel.setShadowScale(0.1);
        this.planeModel.setShadowColor(new Color(255, 255, 0, 192));
        this.planeModelLayer = new RenderableLayer();
        this.planeModelLayer.setName("Plane Model");
        this.planeModelLayer.addRenderable(this.planeModel);
        this.crosshairLayer = new CrosshairLayer("images/64x64-crosshair.png");
        this.crosshairLayer.setOpacity(0.4);
        this.crosshairLayer.setEnabled(false);
        this.trackViewPanel.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void setWwd(WorldWindow worldWindow) {
        if (this.wwd != null) {
            this.wwd.removePropertyChangeListener(this.propertyChangeListener);
            this.wwd.getModel().getGlobe().getElevationModel().removePropertyChangeListener(this.propertyChangeListener);
            this.wwd.getView().removePropertyChangeListener(this.propertyChangeListener);
        }
        this.wwd = worldWindow;
        this.terrainProfilePanel.setWwd(worldWindow);
        if (this.wwd != null) {
            this.wwd.addPropertyChangeListener(this.propertyChangeListener);
            this.wwd.getModel().getGlobe().getElevationModel().addPropertyChangeListener(this.propertyChangeListener);
            this.wwd.getView().addPropertyChangeListener(this.propertyChangeListener);
            ApplicationTemplate.insertBeforeCompass(worldWindow, this.planeModelLayer);
            ApplicationTemplate.insertBeforeCompass(worldWindow, this.crosshairLayer);
        }
    }

    public void setCurrentTrack(SARTrack sARTrack) {
        this.currentTrack = sARTrack;
        this.trackViewPanel.setCurrentTrack(sARTrack);
    }

    private void updateElevationUnit(Object object) {
        if (object != null) {
            this.trackViewPanel.setElevationUnit(object.toString());
            this.trackViewPanel.updateReadout(this.getPositionAlongSegment());
        }
    }

    private Angle getControlHeading() {
        return Angle.ZERO;
    }

    private Angle getControlPitch() {
        return Angle.fromDegrees(80.0);
    }

    private Angle getControlFOV() {
        return Angle.fromDegrees(45.0);
    }

    private void updateView(boolean bl) {
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        orbitView.setFieldOfView(this.getControlFOV());
        if (this.trackViewPanel.isOverrideClipDistance()) {
            orbitView.setNearClipDistance(this.trackViewPanel.getClipDistance());
            orbitView.setDetectCollisions(false);
        } else {
            orbitView.setNearClipDistance(-1.0);
            orbitView.setDetectCollisions(!this.trackViewPanel.isSubsurfaceOkay());
        }
        Position position = this.getPositionAlongSegment();
        if (position != null) {
            Angle angle = this.getHeading().add(this.getControlHeading());
            this.terrainProfilePanel.updatePosition(position, angle);
            this.planeModel.setPosition(position);
            this.planeModel.setHeading(angle);
            this.crosshairLayer.setEnabled(false);
            if (this.trackViewPanel.isExamineViewMode()) {
                this.terrainProfilePanel.setFollowObject();
                Position position2 = this.getSmoothedGroundPositionAlongSegment();
                if (position2 == null) {
                    position2 = this.getGroundPositionAlongSegment();
                }
                if (bl) {
                    Angle angle2 = Angle.fromDegrees(Math.min(60.0, orbitView.getPitch().degrees));
                    double d = 10000.0;
                    if (this.trackViewPanel.isPlayerActive()) {
                        orbitView.setCenterPosition(position2);
                        orbitView.setZoom(d);
                        orbitView.setPitch(angle2);
                    } else {
                        orbitView.applyStateIterator(FlyToOrbitViewStateIterator.createPanToIterator(orbitView, this.wwd.getModel().getGlobe(), position2, orbitView.getHeading(), angle2, d, true));
                    }
                } else {
                    orbitView.stopStateIterators();
                    orbitView.stopMovementOnCenter();
                    try {
                        Position position3 = orbitView.getCurrentEyePosition();
                        LatLon latLon = position3.add(position2.subtract(orbitView.getCenterPosition())).getLatLon();
                        double d = position3.getElevation() < position2.getElevation() ? position2.getElevation() : position3.getElevation();
                        Position position4 = new Position(latLon, d);
                        orbitView.setOrientation(position4, position2);
                    }
                    catch (Exception exception) {
                        orbitView.setCenterPosition(position2);
                    }
                }
            } else if (this.trackViewPanel.isFollowViewMode()) {
                Angle angle3 = Angle.POS90;
                double d = 0.0;
                this.updateCrosshair();
                this.terrainProfilePanel.setFollowObject();
                if (bl) {
                    if (this.trackViewPanel.isPlayerActive()) {
                        orbitView.setCenterPosition(position);
                        orbitView.setHeading(angle);
                        orbitView.setPitch(angle3);
                        orbitView.setZoom(d);
                    } else {
                        orbitView.applyStateIterator(FlyToOrbitViewStateIterator.createPanToIterator(orbitView, this.wwd.getModel().getGlobe(), position, angle, angle3, d));
                    }
                } else {
                    orbitView.stopStateIterators();
                    orbitView.stopMovement();
                    orbitView.setCenterPosition(position);
                    orbitView.setHeading(angle);
                    orbitView.setPitch(angle3);
                    orbitView.setZoom(d);
                }
            } else if (this.trackViewPanel.isFreeViewMode() && bl) {
                orbitView.stopStateIterators();
                orbitView.stopMovement();
                try {
                    orbitView.focusOnViewportCenter();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.trackViewPanel.updateReadout(position);
        this.wwd.redraw();
    }

    private int getCurrentPositionNumber() {
        return this.trackViewPanel.getCurrentPositionNumber();
    }

    private boolean isLastPosition(int n) {
        return n >= this.currentTrack.size() - 1;
    }

    private Position getCurrentSegmentStartPosition() {
        if (this.currentTrack == null || this.currentTrack.size() == 0) {
            return null;
        }
        int n = this.getCurrentPositionNumber();
        SARPosition sARPosition = this.isLastPosition(n) ? this.currentTrack.get(this.currentTrack.size() - 1) : this.currentTrack.get(n);
        return new Position(sARPosition.getLatitude(), sARPosition.getLongitude(), sARPosition.getElevation() + this.currentTrack.getOffset());
    }

    private Position getCurrentSegmentEndPosition() {
        if (this.currentTrack == null || this.currentTrack.size() == 0) {
            return null;
        }
        int n = this.getCurrentPositionNumber();
        SARPosition sARPosition = this.isLastPosition(n + 1) ? this.currentTrack.get(this.currentTrack.size() - 1) : this.currentTrack.get(n + 1);
        return new Position(sARPosition.getLatitude(), sARPosition.getLongitude(), sARPosition.getElevation() + this.currentTrack.getOffset());
    }

    private Position getPositionAlongSegment() {
        double d = this.trackViewPanel.getPositionDelta();
        return this.getPositionAlongSegment(d);
    }

    private Position getPositionAlongSegment(double d) {
        Position position = this.getCurrentSegmentStartPosition();
        if (position == null) {
            return null;
        }
        Position position2 = this.getCurrentSegmentEndPosition();
        if (position2 == null) {
            return position;
        }
        return this.interpolateTrackPosition(d, position, position2);
    }

    private Angle getHeading() {
        SARPosition sARPosition;
        SARPosition sARPosition2;
        int n = this.getCurrentPositionNumber();
        if (!this.isLastPosition(n)) {
            sARPosition2 = this.currentTrack.get(n);
            sARPosition = this.currentTrack.get(n + 1);
        } else {
            sARPosition2 = this.currentTrack.get(n - 1);
            sARPosition = this.currentTrack.get(n);
        }
        return LatLon.greatCircleAzimuth(sARPosition2.getLatLon(), sARPosition.getLatLon());
    }

    private Position getGroundPositionAlongSegment() {
        if (this.wwd == null) {
            return null;
        }
        Position position = this.getPositionAlongSegment();
        if (position == null) {
            return null;
        }
        double d = this.wwd.getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        return new Position(position.getLatLon(), d);
    }

    private Position getSmoothedGroundPositionAlongSegment() {
        if (this.currentTrack == null || this.currentTrack.size() == 0) {
            return null;
        }
        Position position = this.getCurrentSegmentStartPosition();
        Position position2 = this.getCurrentSegmentEndPosition();
        if (position == null || position2 == null) {
            return null;
        }
        Globe globe = this.wwd.getModel().getGlobe();
        if (globe == null) {
            return null;
        }
        int n = this.getCurrentPositionNumber();
        double d = this.trackViewPanel.getPositionDelta();
        if (this.isLastPosition(n)) {
            d = 0.0;
        }
        double d2 = 0.01;
        int n2 = 15;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d5;
            double d6 = d - (double)i * d2;
            Position position3 = null;
            if (d6 >= 0.0) {
                position3 = this.interpolateTrackPosition(d6, position, position2);
            } else if (d6 < 0.0 && n > 0) {
                position3 = this.interpolateTrackPosition(d6 + 1.0, this.currentTrack.get(n - 1), position);
            }
            if (position3 != null) {
                d5 = globe.getElevation(position3.getLatitude(), position3.getLongitude());
                d3 += (double)(n2 - i) * d5;
                d4 += (double)(n2 - i);
            }
            if (i == 0) continue;
            d6 = d + (double)i * d2;
            position3 = null;
            if (d6 <= 1.0) {
                position3 = this.interpolateTrackPosition(d6, position, position2);
            } else if (d6 > 1.0 && !this.isLastPosition(n + 1)) {
                position3 = this.interpolateTrackPosition(d6 - 1.0, position2, this.currentTrack.get(n + 2));
            }
            if (position3 == null) continue;
            d5 = globe.getElevation(position3.getLatitude(), position3.getLongitude());
            d3 += (double)(n2 - i) * d5;
            d4 += (double)(n2 - i);
        }
        Position position4 = this.interpolateTrackPosition(d, position, position2);
        return new Position(position4.getLatLon(), d3 /= d4);
    }

    private Position interpolateTrackPosition(double d, Position position, Position position2) {
        if (position == null || position2 == null) {
            return null;
        }
        LatLon latLon = position.getLatLon();
        LatLon latLon2 = position2.getLatLon();
        Angle angle = LatLon.rhumbAzimuth(latLon, latLon2);
        Angle angle2 = LatLon.rhumbDistance(latLon, latLon2);
        angle2 = angle2.multiply(d);
        LatLon latLon3 = LatLon.rhumbEndPosition(latLon, angle, angle2);
        double d2 = (1.0 - d) * position.getElevation() + d * position2.getElevation();
        return new Position(latLon3, d2);
    }

    private void updateCrosshair() {
        Vec4 vec4 = this.computeCrosshairPosition();
        if (vec4 != null) {
            this.crosshairLayer.setEnabled(true);
            this.crosshairLayer.setLocationCenter(vec4);
        } else {
            this.crosshairLayer.setEnabled(false);
        }
    }

    private Vec4 computeCrosshairPosition() {
        Position position = this.getCurrentSegmentStartPosition();
        Position position2 = this.getCurrentSegmentEndPosition();
        Angle angle = LatLon.rhumbAzimuth(position.getLatLon(), position2.getLatLon());
        Angle angle2 = LatLon.rhumbDistance(position.getLatLon(), position2.getLatLon());
        Globe globe = this.wwd.getModel().getGlobe();
        Plane plane = this.wwd.getView().getFrustumInModelCoordinates().getNear();
        int n = 10;
        double d = 1.0 / (double)n;
        Position position3 = null;
        for (double d2 = 0.0; d2 <= 1.0; d2 += d) {
            Vec4 vec4;
            Object object;
            Object object2;
            Position position4;
            if (d2 == 0.0) {
                position4 = position;
            } else if (d2 >= 1.0) {
                position4 = position2;
            } else {
                object2 = Angle.fromRadians(d2 * angle2.radians);
                object = LatLon.rhumbEndPosition(position.getLatLon(), angle, (Angle)object2);
                position4 = new Position((LatLon)object, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
            }
            if (position3 != null && ((Vec4)(object2 = globe.computePointFromPosition(position3))).distanceTo3((Vec4)(object = globe.computePointFromPosition(position4))) > 0.0 && (vec4 = plane.intersect((Vec4)object2, (Vec4)object)) != null) {
                return this.wwd.getView().project(vec4);
            }
            position3 = position4;
        }
        return null;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.trackViewPanel = new TrackViewPanel();
        this.trackViewPanel.setAlignmentX(0.0f);
        this.add(this.trackViewPanel);
        this.terrainProfilePanel = new TerrainProfilePanel();
        this.terrainProfilePanel.setAlignmentX(0.0f);
        this.add(this.terrainProfilePanel);
    }
}

