/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.util.Logging;
import java.util.logging.Level;

public class BasicModel
extends WWObjectImpl
implements Model {
    private Globe globe;
    private LayerList layers;
    private boolean showWireframeInterior = false;
    private boolean showWireframeExterior = false;
    private boolean showTessellationBoundingVolumes = false;

    public BasicModel() {
        Globe globe = (Globe)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.GlobeClassName");
        this.setGlobe(globe);
        this.createLayers();
    }

    private void createLayers() {
        String[] stringArray;
        LayerList layerList = new LayerList();
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.LayerClassNames", "gov.nasa.worldwind.layers.Earth.BMNGSurfaceLayer");
        if (string == null) {
            return;
        }
        for (String string2 : stringArray = string.split(",")) {
            try {
                if (string2.length() <= 0) continue;
                Layer layer = (Layer)WorldWind.createComponent(string2);
                layerList.add(layer);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicModel.LayerNotFound", string2), exception);
            }
        }
        this.setLayers(layerList);
    }

    public void setGlobe(Globe globe) {
        if (this.globe != null) {
            this.globe.removePropertyChangeListener(this);
        }
        if (globe != null) {
            globe.addPropertyChangeListener(this);
        }
        Globe globe2 = this.globe;
        this.globe = globe;
        this.firePropertyChange("gov.nasa.worldwind.avkey.GlobeObject", globe2, this.globe);
    }

    public void setLayers(LayerList layerList) {
        if (this.layers != null) {
            this.layers.removePropertyChangeListener(this);
        }
        if (layerList != null) {
            layerList.addPropertyChangeListener(this);
        }
        LayerList layerList2 = this.layers;
        this.layers = layerList;
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList2, this.layers);
    }

    public Globe getGlobe() {
        return this.globe;
    }

    public LayerList getLayers() {
        return this.layers;
    }

    public void setShowWireframeInterior(boolean bl) {
        this.showWireframeInterior = bl;
    }

    public void setShowWireframeExterior(boolean bl) {
        this.showWireframeExterior = bl;
    }

    public boolean isShowWireframeInterior() {
        return this.showWireframeInterior;
    }

    public boolean isShowWireframeExterior() {
        return this.showWireframeExterior;
    }

    public boolean isShowTessellationBoundingVolumes() {
        return this.showTessellationBoundingVolumes;
    }

    public void setShowTessellationBoundingVolumes(boolean bl) {
        this.showTessellationBoundingVolumes = bl;
    }

    public Extent getExtent() {
        Object object;
        Object object2;
        LayerList layerList = this.getLayers();
        if (layerList != null) {
            object2 = layerList.iterator();
            while (object2.hasNext()) {
                object = (Layer)object2.next();
                Layer layer = (Layer)object;
                Extent extent = (Extent)layer.getValue("gov.nasa.worldwind.avkey.Extent");
                if (extent == null) continue;
                return extent;
            }
        }
        if ((object2 = this.getGlobe()) != null && (object = object2.getExtent()) != null) {
            return object;
        }
        return null;
    }
}

