/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.TextureCache;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.SectorGeometryList;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.DrawContextImpl;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSceneController
extends WWObjectImpl
implements SceneController {
    private Model model;
    private View view;
    private double verticalExaggeration = 1.0;
    private DrawContext dc = new DrawContextImpl();
    private PickedObjectList lastPickedObjects;
    private long frame = 0L;
    private long timebase = System.currentTimeMillis();
    private double framesPerSecond;
    private double frameTime;
    private double pickTime;
    private Point pickPoint = null;
    private TextureCache textureCache;
    private TextRendererCache textRendererCache = new TextRendererCache();
    private Set<String> perFrameStatisticsKeys = new HashSet<String>();
    private Collection<PerformanceStatistic> perFrameStatistics = new ArrayList<PerformanceStatistic>();
    private ArrayList<Point> pickPoints = new ArrayList();

    public AbstractSceneController() {
        this.setVerticalExaggeration(Configuration.getDoubleValue("gov.nasa.worldwind.avkey.VerticalExaggeration", 1.0));
    }

    @Override
    public void reinitialize() {
        if (this.textRendererCache != null) {
            this.textRendererCache.dispose();
        }
        this.textRendererCache = new TextRendererCache();
    }

    @Override
    public void dispose() {
        if (this.lastPickedObjects != null) {
            this.lastPickedObjects.clear();
        }
        this.lastPickedObjects = null;
        if (this.dc != null) {
            this.dc.dispose();
        }
        if (this.textRendererCache != null) {
            this.textRendererCache.dispose();
        }
    }

    public TextureCache getTextureCache() {
        return this.textureCache;
    }

    @Override
    public void setTextureCache(TextureCache textureCache) {
        this.textureCache = textureCache;
    }

    public TextRendererCache getTextRendererCache() {
        return this.textRendererCache;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public void setModel(Model model) {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
        }
        if (model != null) {
            model.addPropertyChangeListener(this);
        }
        Model model2 = this.model;
        this.model = model;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ModelObject", model2, model);
    }

    @Override
    public void setView(View view) {
        if (this.view != null) {
            this.view.removePropertyChangeListener(this);
        }
        if (view != null) {
            view.addPropertyChangeListener(this);
        }
        View view2 = this.view;
        this.view = view;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", view2, view);
    }

    @Override
    public void setVerticalExaggeration(double d) {
        Double d2 = this.verticalExaggeration;
        this.verticalExaggeration = d;
        this.firePropertyChange("gov.nasa.worldwind.avkey.VerticalExaggeration", d2, d);
    }

    @Override
    public double getVerticalExaggeration() {
        return this.verticalExaggeration;
    }

    @Override
    public void setPickPoint(Point point) {
        this.pickPoint = point;
    }

    @Override
    public Point getPickPoint() {
        return this.pickPoint;
    }

    @Override
    public PickedObjectList getPickedObjectList() {
        return this.lastPickedObjects;
    }

    protected void setPickedObjectList(PickedObjectList pickedObjectList) {
        this.lastPickedObjects = pickedObjectList;
    }

    @Override
    public SectorGeometryList getTerrain() {
        return this.dc.getSurfaceGeometry();
    }

    @Override
    public DrawContext getDrawContext() {
        return this.dc;
    }

    @Override
    public double getFramesPerSecond() {
        return this.framesPerSecond;
    }

    @Override
    public double getFrameTime() {
        return this.frameTime;
    }

    @Override
    public void setPerFrameStatisticsKeys(Set<String> set) {
        this.perFrameStatisticsKeys.clear();
        if (set == null) {
            return;
        }
        for (String string : set) {
            if (string == null) continue;
            this.perFrameStatisticsKeys.add(string);
        }
    }

    @Override
    public Collection<PerformanceStatistic> getPerFrameStatistics() {
        return this.perFrameStatistics;
    }

    @Override
    public void repaint() {
        this.frameTime = System.currentTimeMillis();
        this.perFrameStatistics.clear();
        this.initializeDrawContext(this.dc);
        this.doRepaint(this.dc);
        ++this.frame;
        long l = System.currentTimeMillis();
        this.frameTime = (double)System.currentTimeMillis() - this.frameTime;
        if (l - this.timebase > 2000L) {
            this.framesPerSecond = (double)this.frame * 1000.0 / (double)(l - this.timebase);
            this.timebase = l;
            this.frame = 0L;
        }
        this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.FrameTime", "Frame Time (ms)", (int)this.frameTime);
        this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.FrameRate", "Frame Rate (fps)", (int)this.framesPerSecond);
        this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.PickTime", "Pick Time (ms)", (int)this.pickTime);
        Set<String> set = this.dc.getPerFrameStatisticsKeys();
        if (set == null) {
            return;
        }
        if (set.contains("gov.nasa.worldwind.perfstat.MemoryCache") || set.contains("gov.nasa.worldwind.perfstat.All")) {
            this.dc.setPerFrameStatistics(WorldWind.getMemoryCacheSet().getPerformanceStatistics());
        }
        if ((set.contains("gov.nasa.worldwind.perfstat.TextureCache") || set.contains("gov.nasa.worldwind.perfstat.All")) && this.dc.getTextureCache() != null) {
            this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.TextureCache", "Texture Cache size (Kb)", this.dc.getTextureCache().getUsedCapacity() / 1000L);
        }
    }

    protected abstract void doRepaint(DrawContext var1);

    private void initializeDrawContext(DrawContext drawContext) {
        drawContext.initialize(GLContext.getCurrent());
        drawContext.setPerFrameStatisticsKeys(this.perFrameStatisticsKeys, this.perFrameStatistics);
        drawContext.setTextureCache(this.textureCache);
        drawContext.setTextRendererCache(this.textRendererCache);
        drawContext.setModel(this.model);
        drawContext.setView(this.view);
        drawContext.setVerticalExaggeration(this.verticalExaggeration);
        drawContext.setPickPoint(this.pickPoint);
        drawContext.setViewportCenterScreenPoint(this.getViewportCenter(drawContext));
    }

    private Point getViewportCenter(DrawContext drawContext) {
        View view = drawContext.getView();
        if (view == null) {
            return null;
        }
        Rectangle rectangle = view.getViewport();
        if (rectangle == null) {
            return null;
        }
        return new Point((int)(rectangle.getCenterX() + 0.5), (int)(rectangle.getCenterY() + 0.5));
    }

    protected void initializeFrame(DrawContext drawContext) {
        if (drawContext.getGLContext() == null) {
            String string = Logging.getMessage("BasicSceneController.GLContextNullStartRedisplay");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(14336);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glEnable(2929);
    }

    protected void clearFrame(DrawContext drawContext) {
        Color color = drawContext.getClearColor();
        drawContext.getGL().glClearColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        drawContext.getGL().glClear(16640);
    }

    protected void finalizeFrame(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    protected void applyView(DrawContext drawContext) {
        if (drawContext.getView() != null) {
            drawContext.getView().apply(drawContext);
        }
    }

    protected void createTerrain(DrawContext drawContext) {
        if (drawContext.getSurfaceGeometry() == null) {
            if (drawContext.getModel() != null && drawContext.getModel().getGlobe() != null) {
                SectorGeometryList sectorGeometryList = drawContext.getModel().getGlobe().tessellate(drawContext);
                drawContext.setSurfaceGeometry(sectorGeometryList);
                drawContext.setVisibleSector(sectorGeometryList.getSector());
            }
            if (drawContext.getSurfaceGeometry() == null) {
                Logging.logger().warning("generic.NoSurfaceGeometry");
                drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.TerrainTileCount", "Terrain Tiles", 0);
            }
            drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.TerrainTileCount", "Terrain Tiles", drawContext.getSurfaceGeometry().size());
        }
    }

    protected void pickTerrain(DrawContext drawContext) {
        if (drawContext.isPickingMode() && drawContext.getVisibleSector() != null && drawContext.getSurfaceGeometry() != null && drawContext.getSurfaceGeometry().size() > 0) {
            this.pickPoints.clear();
            if (drawContext.getPickPoint() != null) {
                this.pickPoints.add(drawContext.getPickPoint());
            }
            drawContext.setViewportCenterPosition(null);
            Point point = drawContext.getViewportCenterScreenPoint();
            if (point != null) {
                this.pickPoints.add(point);
            }
            if (this.pickPoints.size() == 0) {
                return;
            }
            ArrayList<PickedObject> arrayList = drawContext.getSurfaceGeometry().pick(drawContext, this.pickPoints);
            if (arrayList == null || arrayList.size() == 0) {
                return;
            }
            for (PickedObject pickedObject : arrayList) {
                if (pickedObject == null) continue;
                if (pickedObject.getPickPoint().equals(drawContext.getPickPoint())) {
                    drawContext.addPickedObject(pickedObject);
                    continue;
                }
                if (!pickedObject.getPickPoint().equals(point)) continue;
                drawContext.setViewportCenterPosition((Position)pickedObject.getObject());
            }
        }
    }

    protected void pickLayers(DrawContext drawContext) {
        if (drawContext.getLayers() != null) {
            for (Layer layer : drawContext.getLayers()) {
                try {
                    if (layer == null || !layer.isPickEnabled()) continue;
                    layer.pick(drawContext, drawContext.getPickPoint());
                }
                catch (Exception exception) {
                    String string = Logging.getMessage("SceneController.ExceptionWhilePickingInLayer", layer != null ? layer.getClass().getName() : Logging.getMessage("term.unknown"));
                    Logging.logger().log(Level.SEVERE, string, exception);
                }
            }
        }
    }

    protected void resolveTopPick(DrawContext drawContext) {
        PickedObjectList pickedObjectList = drawContext.getPickedObjects();
        if (pickedObjectList != null && pickedObjectList.size() == 1) {
            ((PickedObject)pickedObjectList.get(0)).setOnTop();
        } else if (pickedObjectList != null && pickedObjectList.size() > 1) {
            int[] nArray = new int[4];
            ByteBuffer byteBuffer = BufferUtil.newByteBuffer(3);
            GL gL = drawContext.getGL();
            gL.glGetIntegerv(2978, nArray, 0);
            gL.glReadPixels(drawContext.getPickPoint().x, nArray[3] - drawContext.getPickPoint().y, 1, 1, 6407, 5121, byteBuffer);
            Color color = new Color(byteBuffer.get(0) & 0xFF, byteBuffer.get(1) & 0xFF, byteBuffer.get(2) & 0xFF, 0);
            int n = color.getRGB();
            if (0 != n) {
                for (PickedObject pickedObject : pickedObjectList) {
                    if (null == pickedObject || pickedObject.getColorCode() != n) continue;
                    pickedObject.setOnTop();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pick(DrawContext drawContext) {
        this.pickTime = System.currentTimeMillis();
        this.lastPickedObjects = null;
        try {
            drawContext.enablePickingMode();
            this.pickTerrain(drawContext);
            if (drawContext.getPickPoint() == null) {
                return;
            }
            this.pickLayers(drawContext);
            while (drawContext.getOrderedRenderables().peek() != null) {
                drawContext.getOrderedRenderables().poll().pick(drawContext, drawContext.getPickPoint());
            }
            this.resolveTopPick(drawContext);
            this.lastPickedObjects = new PickedObjectList(drawContext.getPickedObjects());
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicSceneController.ExceptionDuringPick"), throwable);
        }
        finally {
            drawContext.disablePickingMode();
            this.pickTime = (double)System.currentTimeMillis() - this.pickTime;
        }
    }

    protected void draw(DrawContext drawContext) {
        try {
            if (drawContext.getLayers() != null) {
                for (Object object : drawContext.getLayers()) {
                    try {
                        if (object == null) continue;
                        object.render(drawContext);
                    }
                    catch (Exception exception) {
                        Object object2 = Logging.getMessage("SceneController.ExceptionWhileRenderingLayer", object != null ? object.getClass().getName() : Logging.getMessage("term.unknown"));
                        Logging.logger().log(Level.SEVERE, (String)object2, exception);
                    }
                }
            }
            while (drawContext.getOrderedRenderables().peek() != null) {
                drawContext.getOrderedRenderables().poll().render(drawContext);
            }
            if (drawContext.getSurfaceGeometry() != null && drawContext.getModel() != null && (drawContext.getModel().isShowWireframeExterior() || drawContext.getModel().isShowWireframeInterior() || drawContext.getModel().isShowTessellationBoundingVolumes())) {
                Object object;
                Model model = drawContext.getModel();
                object = new float[4];
                drawContext.getGL().glGetFloatv(2816, (float[])object, 0);
                for (Object object2 : drawContext.getSurfaceGeometry()) {
                    if (model.isShowWireframeInterior() || model.isShowWireframeExterior()) {
                        object2.renderWireframe(drawContext, model.isShowWireframeInterior(), model.isShowWireframeExterior());
                    }
                    if (!model.isShowTessellationBoundingVolumes()) continue;
                    drawContext.getGL().glColor3d(1.0, 0.0, 0.0);
                    object2.renderBoundingVolume(drawContext);
                }
                drawContext.getGL().glColor4fv((float[])object, 0);
            }
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicSceneController.ExceptionDuringRendering"), throwable);
        }
    }

    protected void checkGLErrors(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = gL.glGetError();
        if (n != 0) {
            String string = drawContext.getGLU().gluErrorString(n);
            string = string + n;
            Logging.logger().severe(string);
        }
    }
}

