/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import ncsa.hdf.object.Datatype;

public class H4Datatype
extends Datatype {
    private static final long serialVersionUID = -1342029403385521874L;

    public H4Datatype(int tclass, int tsize, int torder, int tsign) {
        super(tclass, tsize, torder, tsign);
    }

    public H4Datatype(int nativeID) {
        super(nativeID);
        this.fromNative(nativeID);
    }

    public boolean hasAttribute() {
        return false;
    }

    public void fromNative(int tid) {
        this.datatypeOrder = -1;
        this.datatypeSign = -1;
        switch (tid) {
            case 4: {
                this.datatypeClass = 2;
                this.datatypeSize = 1;
                break;
            }
            case 3: {
                this.datatypeClass = 2;
                this.datatypeSize = 1;
                this.datatypeSign = 0;
                break;
            }
            case 20: {
                this.datatypeClass = 0;
                this.datatypeSize = 1;
                break;
            }
            case 21: {
                this.datatypeClass = 0;
                this.datatypeSize = 1;
                this.datatypeSign = 0;
                break;
            }
            case 22: {
                this.datatypeClass = 0;
                this.datatypeSize = 2;
                break;
            }
            case 23: {
                this.datatypeClass = 0;
                this.datatypeSize = 2;
                this.datatypeSign = 0;
                break;
            }
            case 24: {
                this.datatypeClass = 0;
                this.datatypeSize = 4;
                break;
            }
            case 25: {
                this.datatypeClass = 0;
                this.datatypeSize = 4;
                this.datatypeSign = 0;
                break;
            }
            case 26: {
                this.datatypeClass = 0;
                this.datatypeSize = 8;
                break;
            }
            case 27: {
                this.datatypeClass = 0;
                this.datatypeSize = 8;
                this.datatypeSign = 0;
                break;
            }
            case 5: {
                this.datatypeClass = 1;
                this.datatypeSize = 4;
                break;
            }
            case 6: {
                this.datatypeClass = 1;
                this.datatypeSize = 8;
                break;
            }
            default: {
                this.datatypeClass = -1;
            }
        }
    }

    public static final Object allocateArray(int datatype, int datasize) throws OutOfMemoryError {
        if (datasize <= 0) {
            return null;
        }
        Object[] data = null;
        switch (datatype) {
            case 3: 
            case 4: 
            case 20: 
            case 21: {
                data = new byte[datasize];
                break;
            }
            case 22: 
            case 23: {
                data = new short[datasize];
                break;
            }
            case 24: 
            case 25: {
                data = new int[datasize];
                break;
            }
            case 26: 
            case 27: {
                data = new long[datasize];
                break;
            }
            case 5: {
                data = new float[datasize];
                break;
            }
            case 6: {
                data = new double[datasize];
                break;
            }
            default: {
                data = null;
            }
        }
        return data;
    }

    public String getDatatypeDescription() {
        return H4Datatype.getDatatypeDescription(this.toNative());
    }

    public static final String getDatatypeDescription(int datatype) {
        String description = "Unknown";
        switch (datatype) {
            case 4: {
                description = "8-bit character";
                break;
            }
            case 3: {
                description = "8-bit unsigned character";
                break;
            }
            case 21: {
                description = "8-bit unsigned integer";
                break;
            }
            case 20: {
                description = "8-bit integer";
                break;
            }
            case 22: {
                description = "16-bit integer";
                break;
            }
            case 23: {
                description = "16-bit unsigned integer";
                break;
            }
            case 24: {
                description = "32-bit integer";
                break;
            }
            case 25: {
                description = "32-bit unsigned integer";
                break;
            }
            case 26: {
                description = "64-bit integer";
                break;
            }
            case 27: {
                description = "64-bit unsigned integer";
                break;
            }
            case 5: {
                description = "32-bit floating-point";
                break;
            }
            case 6: {
                description = "64-bit floating-point";
                break;
            }
            default: {
                description = "Unknown";
            }
        }
        return description;
    }

    public boolean isUnsigned() {
        return H4Datatype.isUnsigned(this.toNative());
    }

    public static final boolean isUnsigned(int datatype) {
        boolean unsigned = false;
        switch (datatype) {
            case 3: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                unsigned = true;
                break;
            }
            default: {
                unsigned = false;
            }
        }
        return unsigned;
    }

    public int toNative() {
        int tid = -1;
        int tclass = this.getDatatypeClass();
        int tsize = this.getDatatypeSize();
        int torder = this.getDatatypeOrder();
        int tsign = this.getDatatypeSign();
        switch (tclass) {
            case 0: {
                if (tsize == 1) {
                    if (tsign == 0) {
                        tid = 21;
                        break;
                    }
                    tid = 20;
                    break;
                }
                if (tsize == 2) {
                    if (tsign == 0) {
                        tid = 23;
                        break;
                    }
                    tid = 22;
                    break;
                }
                if (tsize == 4 || tsize == -1) {
                    if (tsign == 0) {
                        tid = 25;
                        break;
                    }
                    tid = 24;
                    break;
                }
                if (tsize != 8) break;
                if (tsign == 0) {
                    tid = 27;
                    break;
                }
                tid = 26;
                break;
            }
            case 1: {
                if (tsize == -1) {
                    tid = 5;
                    break;
                }
                if (tsize == 4) {
                    tid = 5;
                    break;
                }
                if (tsize != 8) break;
                tid = 6;
                break;
            }
            case 2: {
                if (tsign == 0) {
                    tid = 3;
                    break;
                }
                tid = 4;
                break;
            }
            case 3: {
                tid = 4;
            }
        }
        return tid;
    }

    public void close(int id) {
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

