/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import org.geotools.feature.IllegalAttributeException;
import org.geotools.util.Converters;
import org.opengis.feature.Attribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.Filter;

public class Types {
    public static boolean isValid(Attribute attribute) {
        try {
            Types.validate(attribute.getType(), attribute, attribute.getValue(), false);
            return true;
        }
        catch (IllegalAttributeException invalid) {
            return false;
        }
    }

    public static void validate(Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(attribute.getType(), attribute, attributeContent, false);
    }

    public static void validate(AttributeType type, Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(type, attribute, attributeContent, false);
    }

    protected static void validate(AttributeType type, Attribute attribute, Object attributeContent, boolean isSuper) throws IllegalAttributeException {
        if (type == null) {
            throw new IllegalAttributeException("null type");
        }
        if (attributeContent == null) {
            if (!attribute.isNillable()) {
                throw new IllegalAttributeException(type.getName() + " not nillable");
            }
            return;
        }
        if (type.isIdentified() && attribute.getIdentifier() == null) {
            throw new NullPointerException(type.getName() + " is identified, null id not accepted");
        }
        if (!isSuper) {
            Class<?> clazz = attributeContent.getClass();
            Class binding = type.getBinding();
            if (binding != null && binding != clazz && !binding.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + type.getName() + " as it is not assignable from " + binding);
            }
        }
        if (type.getRestrictions() != null) {
            for (Filter f : type.getRestrictions()) {
                if (f.evaluate((Object)attribute)) continue;
                throw new IllegalAttributeException("Attribute instance (" + attribute.getIdentifier() + ")" + "fails to pass filter: " + f);
            }
        }
        if (type.getSuper() != null) {
            Types.validate(type.getSuper(), attribute, attributeContent, true);
        }
    }

    public static void validate(AttributeDescriptor descriptor, Object value) throws IllegalAttributeException {
        if (descriptor == null) {
            throw new NullPointerException("Attribute descriptor required for validation");
        }
        if (value == null) {
            if (!descriptor.isNillable()) {
                throw new IllegalArgumentException(descriptor.getName() + " requires a non null value");
            }
        } else {
            Types.validate(descriptor.getType(), value, false);
        }
    }

    public static Object parse(AttributeDescriptor descriptor, Object value) throws IllegalArgumentException {
        if (value == null) {
            if (descriptor.isNillable()) {
                return descriptor.getDefaultValue();
            }
        } else {
            Object converted;
            Class target = descriptor.getType().getBinding();
            if (!target.isAssignableFrom(value.getClass()) && (converted = Converters.convert(value, target)) != null) {
                return converted;
            }
        }
        return value;
    }

    protected static void validate(AttributeType type, Object value, boolean isSuper) throws IllegalAttributeException {
        if (!isSuper) {
            Class<?> clazz = value.getClass();
            Class binding = type.getBinding();
            if (binding != null && !binding.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + type.getName() + " as it is not assignable from " + binding);
            }
        }
        if (type.getRestrictions() != null && type.getRestrictions().size() > 0) {
            for (Filter filter : type.getRestrictions()) {
                if (filter.evaluate(value)) continue;
                throw new IllegalAttributeException(type.getName() + " restriction " + filter + " not met by: " + value);
            }
        }
        if (type.getSuper() != null) {
            Types.validate(type.getSuper(), value, true);
        }
    }
}

