/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.expression.Expression;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class GridCoverageRenderer {
    private static final boolean DEBUG = Boolean.getBoolean("org.geotools.renderer.lite.gridcoverage2d.debug");
    private static String debugDir;
    private static final Crop coverageCropFactory;
    private static final Logger LOGGER;
    private final CoordinateReferenceSystem destinationCRS;
    private final GeneralEnvelope destinationEnvelope;
    private final Rectangle destinationSize;
    private final AffineTransform finalGridToWorld;
    private final AffineTransform finalWorldToGrid;
    private final Hints hints = new Hints();
    private static final ParameterValueGroup resampleParams;
    private static ParameterValueGroup cropParams;
    private static final Resample resampleFactory;

    static float getOpacity(RasterSymbolizer symbolizer) {
        float alpha = 1.0f;
        Expression exp = symbolizer.getOpacity();
        if (exp == null) {
            return alpha;
        }
        Number number = (Number)exp.evaluate(null, Float.class);
        if (number == null) {
            return alpha;
        }
        return number.floatValue();
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize) throws TransformException, NoninvertibleTransformException {
        this(destinationCRS, envelope, screenSize, null);
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize, RenderingHints java2dHints) throws TransformException, NoninvertibleTransformException {
        this.destinationSize = screenSize;
        this.destinationCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)destinationCRS);
        if (this.destinationCRS == null) {
            throw new TransformException(Errors.format((int)164, (Object)destinationCRS));
        }
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper();
        gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        gridToEnvelopeMapper.setGridRange((GridEnvelope)new GridEnvelope2D(this.destinationSize));
        this.destinationEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)new ReferencedEnvelope(envelope, destinationCRS));
        gridToEnvelopeMapper.setEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
        this.finalGridToWorld = new AffineTransform(gridToEnvelopeMapper.createAffineTransform());
        this.finalWorldToGrid = this.finalGridToWorld.createInverse();
        if (java2dHints != null) {
            this.hints.add(java2dHints);
        }
        this.hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        this.hints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
    }

    private static GridCoverage2D resample(GridCoverage2D gc, CoordinateReferenceSystem crs, Interpolation interpolation, GeneralEnvelope destinationEnvelope, Hints hints) throws FactoryException {
        assert (CRS.equalsIgnoreMetadata((Object)destinationEnvelope.getCoordinateReferenceSystem(), (Object)crs) || CRS.findMathTransform((CoordinateReferenceSystem)destinationEnvelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)crs).isIdentity());
        ParameterValueGroup param = resampleParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)crs);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        return (GridCoverage2D)resampleFactory.doOperation(param, hints);
    }

    private static GridCoverage2D getCroppedCoverage(GridCoverage2D gc, GeneralEnvelope envelope, CoordinateReferenceSystem crs, Hints hints) {
        GeneralEnvelope oldEnvelope = (GeneralEnvelope)gc.getEnvelope();
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)envelope);
        intersectionEnvelope.setCoordinateReferenceSystem(crs);
        intersectionEnvelope.intersect((org.opengis.geometry.Envelope)oldEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            return null;
        }
        ParameterValueGroup param = cropParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("Envelope").setValue((Object)intersectionEnvelope);
        return (GridCoverage2D)coverageCropFactory.doOperation(param, hints);
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer) throws FactoryException, TransformException, NoninvertibleTransformException {
        GridCoverage2D preSymbolizer;
        GeneralEnvelope destinationEnvelopeInSourceCRS;
        boolean doReprojection;
        GeneralEnvelope sourceCoverageEnvelope;
        CoordinateReferenceSystem sourceCoverageCRS;
        block44: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Drawing coverage " + gridCoverage.toString());
            }
            sourceCoverageCRS = gridCoverage.getCoordinateReferenceSystem2D();
            sourceCoverageEnvelope = (GeneralEnvelope)gridCoverage.getEnvelope();
            MathTransform sourceCRSToDestinationCRSTransformation = CRS.findMathTransform((CoordinateReferenceSystem)sourceCoverageCRS, (CoordinateReferenceSystem)this.destinationCRS, (boolean)true);
            MathTransform destinationCRSToSourceCRSTransformation = sourceCRSToDestinationCRSTransformation.inverse();
            boolean bl = doReprojection = !sourceCRSToDestinationCRSTransformation.isIdentity();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Transforming coverage envelope with transform " + destinationCRSToSourceCRSTransformation.toWKT());
            }
            if (doReprojection) {
                try {
                    destinationEnvelopeInSourceCRS = CRS.transform((MathTransform)destinationCRSToSourceCRSTransformation, (org.opengis.geometry.Envelope)this.destinationEnvelope);
                }
                catch (TransformException te) {
                    GeneralEnvelope destinationEnvelopeWGS84;
                    if (!CRS.equalsIgnoreMetadata((Object)this.destinationCRS, (Object)DefaultGeographicCRS.WGS84)) {
                        MathTransform destinationCRSToWGS84transformation = CRS.findMathTransform((CoordinateReferenceSystem)this.destinationCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
                        if (!destinationCRSToWGS84transformation.isIdentity()) {
                            destinationEnvelopeWGS84 = CRS.transform((MathTransform)destinationCRSToWGS84transformation, (org.opengis.geometry.Envelope)this.destinationEnvelope);
                            destinationEnvelopeWGS84.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                        } else {
                            destinationEnvelopeWGS84 = new GeneralEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
                        }
                    } else {
                        destinationEnvelopeWGS84 = new GeneralEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
                    }
                    if (!CRS.equalsIgnoreMetadata((Object)sourceCoverageCRS, (Object)DefaultGeographicCRS.WGS84)) {
                        MathTransform WGS84ToSourceCoverageCRSTransformation = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)sourceCoverageCRS, (boolean)true);
                        if (!WGS84ToSourceCoverageCRSTransformation.isIdentity()) {
                            destinationEnvelopeInSourceCRS = CRS.transform((MathTransform)WGS84ToSourceCoverageCRSTransformation, (org.opengis.geometry.Envelope)destinationEnvelopeWGS84);
                            destinationEnvelopeInSourceCRS.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                        } else {
                            destinationEnvelopeInSourceCRS = new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelopeWGS84);
                        }
                        break block44;
                    }
                    destinationEnvelopeInSourceCRS = new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelopeWGS84);
                }
            } else {
                destinationEnvelopeInSourceCRS = new GeneralEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
            }
        }
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelopeInSourceCRS);
        intersectionEnvelope.intersect((org.opengis.geometry.Envelope)sourceCoverageEnvelope);
        if (intersectionEnvelope.isEmpty() || intersectionEnvelope.isNull()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.warning("The destination envelope does not intersect the envelope of the source coverage.");
            }
            return;
        }
        Interpolation interpolation = (Interpolation)this.hints.get((Object)JAI.KEY_INTERPOLATION);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Using interpolation " + interpolation);
        }
        GridCoverage2D preResample = gridCoverage;
        try {
            preResample = GridCoverageRenderer.getCroppedCoverage(gridCoverage, intersectionEnvelope, sourceCoverageCRS, this.hints);
            if (preResample == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Skipping current coverage because cropped to an empty area");
                }
                return;
            }
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Crop Failed for reason: " + t.getLocalizedMessage());
            }
            preResample = gridCoverage;
        }
        if (DEBUG) {
            try {
                ImageIO.write(preResample.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "cropped.tiff"));
            }
            catch (IOException e) {
                LOGGER.info(e.getLocalizedMessage());
            }
        }
        if (doReprojection) {
            preSymbolizer = GridCoverageRenderer.resample(preResample, this.destinationCRS, (Interpolation)(interpolation == null ? new InterpolationNearest() : interpolation), this.destinationEnvelope, this.hints);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Reprojecting to crs " + this.destinationCRS.toWKT());
            }
        } else {
            preSymbolizer = preResample;
        }
        if (DEBUG) {
            try {
                ImageIO.write(preSymbolizer.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "preSymbolizer.tiff"));
            }
            catch (IOException e) {
                LOGGER.info(e.getLocalizedMessage());
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Raster Symbolizer ");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Raster Symbolizer ").toString());
        }
        RasterSymbolizerHelper rsp = new RasterSymbolizerHelper(preSymbolizer, this.hints);
        rsp.visit(symbolizer);
        GridCoverage2D recoloredGridCoverage = (GridCoverage2D)rsp.getOutput();
        RenderedImage finalImage = recoloredGridCoverage.geophysics(false).getRenderedImage();
        GridGeometry2D recoloredCoverageGridGeometry = recoloredGridCoverage.getGridGeometry();
        MathTransform2D finalGCTransform = recoloredCoverageGridGeometry.getGridToCRS2D();
        if (!(finalGCTransform instanceof AffineTransform)) {
            throw new UnsupportedOperationException("Non-affine transformations not yet implemented");
        }
        AffineTransform finalGCgridToWorld = new AffineTransform((AffineTransform)finalGCTransform);
        finalGCgridToWorld.translate(-0.5, -0.5);
        AffineTransform clonedFinalWorldToGrid = (AffineTransform)this.finalWorldToGrid.clone();
        clonedFinalWorldToGrid.concatenate(finalGCgridToWorld);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("clonedFinalWorldToGrid " + clonedFinalWorldToGrid.toString());
        }
        RenderingHints oldHints = graphics.getRenderingHints();
        graphics.setRenderingHints((Map<?, ?>)this.hints);
        float alpha = GridCoverageRenderer.getOpacity(symbolizer);
        Composite oldAlphaComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, alpha));
        try {
            graphics.drawRenderedImage(finalImage, clonedFinalWorldToGrid);
        }
        catch (Throwable t) {
            try {
                if (DEBUG) {
                    try {
                        ImageIO.write(finalImage, "tiff", new File(debugDir, "final0.tiff"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedImage buf = new BufferedImage(finalImage.getWidth(), finalImage.getHeight(), 6);
                Graphics2D g = (Graphics2D)buf.getGraphics();
                g.drawRenderedImage(finalImage, AffineTransform.getScaleInstance(1.0, 1.0));
                g.dispose();
                if (DEBUG) {
                    try {
                        ImageIO.write((RenderedImage)buf, "tiff", new File(debugDir, "final1.tiff"));
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                graphics.drawImage(buf, clonedFinalWorldToGrid, null);
                buf.flush();
            }
            catch (Throwable t1) {
                LOGGER.log(Level.WARNING, t1.getLocalizedMessage(), t1);
            }
        }
        graphics.setComposite(oldAlphaComposite);
        graphics.setRenderingHints(oldHints);
    }

    static {
        if (DEBUG) {
            File tempDir = new File("c:\\temp");
            if (!tempDir.exists() || !tempDir.canWrite()) {
                System.out.println("Unable to create debug dir, exiting application!!!");
                System.exit(1);
                debugDir = null;
            } else {
                debugDir = tempDir.getAbsolutePath();
            }
        }
        coverageCropFactory = new Crop();
        LOGGER = Logging.getLogger((String)"org.geotools.rendering");
        DefaultProcessor processor = new DefaultProcessor((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        resampleParams = processor.getOperation("Resample").getParameters();
        cropParams = processor.getOperation("CoverageCrop").getParameters();
        resampleFactory = new Resample();
    }
}

