/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class DataInOutUtils {
    public static int readInt4(InputStream is) throws IOException {
        int value = 0;
        int shVal = 0;
        int neeble = 8;
        while ((neeble & 8) != 0) {
            int octet = is.read();
            if (octet == -1) {
                throw new EOFException();
            }
            neeble = octet >> 4;
            value |= (neeble & 7) << shVal;
            if ((neeble & 8) != 0) {
                neeble = octet & 0xF;
                value |= (neeble & 7) << shVal + 3;
            }
            shVal += 6;
        }
        return value;
    }

    public static void readInts4(InputStream is, int[] array, int count) throws IOException {
        DataInOutUtils.readInts4(is, array, count, 0);
    }

    public static int readInts4(InputStream is, int[] array, int count, int lowValue) throws IOException {
        int value = 0;
        int octet = 0;
        int readInts = 0;
        int shVal = 0;
        int neeble = 0;
        int neebleNum = 0;
        if (lowValue > 0) {
            octet = lowValue & 0xF;
            neebleNum = 1;
        }
        while (readInts < count) {
            if (neebleNum % 2 == 0) {
                octet = is.read();
                if (octet == -1) {
                    throw new EOFException();
                }
                neeble = octet >> 4;
            } else {
                neeble = octet & 0xF;
            }
            value |= (neeble & 7) << shVal;
            if ((neeble & 8) == 0) {
                array[readInts++] = value;
                shVal = 0;
                value = 0;
            } else {
                shVal += 3;
            }
            ++neebleNum;
        }
        if (neebleNum % 2 != 0) {
            return 0x80 | octet & 0xF;
        }
        return 0;
    }

    public static void readInts4(ByteBuffer buffer, int[] array, int count) throws IOException {
        DataInOutUtils.readInts4(buffer, array, count, 0);
    }

    public static int readInts4(ByteBuffer buffer, int[] array, int count, int lowValue) throws IOException {
        int value = 0;
        int octet = 0;
        int readInts = 0;
        int shVal = 0;
        int neeble = 0;
        int neebleNum = 0;
        if (lowValue > 0) {
            octet = lowValue & 0xF;
            neebleNum = 1;
        }
        while (readInts < count) {
            if (neebleNum % 2 == 0) {
                if (!buffer.hasRemaining()) {
                    throw new EOFException();
                }
                octet = buffer.get();
                neeble = octet >> 4;
            } else {
                neeble = octet & 0xF;
            }
            value |= (neeble & 7) << shVal;
            if ((neeble & 8) == 0) {
                array[readInts++] = value;
                shVal = 0;
                value = 0;
            } else {
                shVal += 3;
            }
            ++neebleNum;
        }
        if (neebleNum % 2 != 0) {
            return 0x80 | octet & 0xF;
        }
        return 0;
    }

    public static void writeInt4(OutputStream os, int value) throws IOException {
        do {
            int nibbleL;
            int nibbleH = value & 7;
            if ((value >>>= 3) != 0) {
                nibbleH |= 8;
                nibbleL = value & 7;
                if ((value >>>= 3) != 0) {
                    nibbleL |= 8;
                }
            } else {
                nibbleL = 0;
            }
            os.write(nibbleL | nibbleH << 4);
        } while (value != 0);
    }

    public static int readInt8(InputStream is) throws IOException {
        int value = 0;
        int shVal = 0;
        int octet = 128;
        while ((octet & 0x80) != 0) {
            octet = is.read();
            if (octet == -1) {
                throw new EOFException();
            }
            value |= (octet & 0x7F) << shVal;
            shVal += 7;
        }
        return value;
    }

    public static void writeInt8(OutputStream os, int value) throws IOException {
        do {
            int octet = value & 0x7F;
            if ((value >>>= 7) != 0) {
                octet |= 0x80;
            }
            os.write(octet);
        } while (value != 0);
    }

    public static void writeInt8(ByteBuffer bb, int value) throws IOException {
        do {
            int octet = value & 0x7F;
            if ((value >>>= 7) != 0) {
                octet |= 0x80;
            }
            bb.put((byte)octet);
        } while (value != 0);
    }

    public static int readInt4(ByteBuffer buffer) throws IOException {
        int value = 0;
        int shVal = 0;
        int neeble = 8;
        while ((neeble & 8) != 0) {
            if (!buffer.hasRemaining()) {
                throw new EOFException();
            }
            byte octet = buffer.get();
            neeble = octet >> 4;
            value |= (neeble & 7) << shVal;
            if ((neeble & 8) != 0) {
                neeble = octet & 0xF;
                value |= (neeble & 7) << shVal + 3;
            }
            shVal += 6;
        }
        return value;
    }

    public static void writeInts4(ByteBuffer bb, int ... values) throws IOException {
        DataInOutUtils.writeInts4(bb, values, 0, values.length);
    }

    public static void writeInts4(ByteBuffer bb, int[] array, int offset, int count) throws IOException {
        int shiftValue = 0;
        for (int i = 0; i < count - 1; ++i) {
            int value = array[offset + i];
            shiftValue = DataInOutUtils.writeInt4(bb, value, shiftValue, false);
        }
        if (count > 0) {
            DataInOutUtils.writeInt4(bb, array[offset + count - 1], shiftValue, true);
        }
    }

    public static void writeInts4(OutputStream out, int ... values) throws IOException {
        DataInOutUtils.writeInts4(out, values, 0, values.length);
    }

    public static void writeInts4(OutputStream out, int[] array, int offset, int count) throws IOException {
        int shiftValue = 0;
        for (int i = 0; i < count - 1; ++i) {
            int value = array[offset + i];
            shiftValue = DataInOutUtils.writeInt4(out, value, shiftValue, false);
        }
        if (count > 0) {
            DataInOutUtils.writeInt4(out, array[offset + count - 1], shiftValue, true);
        }
    }

    public static int writeInt4(OutputStream out, int value, int highValue, boolean flush) throws IOException {
        int nibbleL;
        if (highValue > 0) {
            highValue &= 0x70;
            nibbleL = value & 7;
            if ((value >>>= 3) != 0) {
                nibbleL |= 8;
            }
            out.write(highValue | nibbleL);
            if (value == 0) {
                return 0;
            }
        }
        do {
            int nibbleH = (value & 7) << 4;
            if ((value >>>= 3) != 0) {
                nibbleH |= 0x80;
                nibbleL = value & 7;
                if ((value >>>= 3) != 0) {
                    nibbleL |= 8;
                }
            } else {
                if (!flush) {
                    return nibbleH | 0x80;
                }
                nibbleL = 0;
            }
            out.write(nibbleH | nibbleL);
        } while (value != 0);
        return 0;
    }

    public static int writeInt4(ByteBuffer bb, int value, int highValue, boolean flush) throws IOException {
        int nibbleL;
        if (highValue > 0) {
            highValue &= 0x70;
            nibbleL = value & 7;
            if ((value >>>= 3) != 0) {
                nibbleL |= 8;
            }
            bb.put((byte)(highValue | nibbleL));
            if (value == 0) {
                return 0;
            }
        }
        do {
            int nibbleH = (value & 7) << 4;
            if ((value >>>= 3) != 0) {
                nibbleH |= 0x80;
                nibbleL = value & 7;
                if ((value >>>= 3) != 0) {
                    nibbleL |= 8;
                }
            } else {
                if (!flush) {
                    return nibbleH | 0x80;
                }
                nibbleL = 0;
            }
            bb.put((byte)(nibbleH | nibbleL));
        } while (value != 0);
        return 0;
    }

    public static int readInt8(ByteBuffer buffer) throws IOException {
        int value = 0;
        int shVal = 0;
        int octet = 128;
        while ((octet & 0x80) != 0) {
            if (!buffer.hasRemaining()) {
                throw new EOFException();
            }
            octet = buffer.get();
            value |= (octet & 0x7F) << shVal;
            shVal += 7;
        }
        return value;
    }

    public static void readFully(InputStream inputStream, byte[] buffer) throws IOException {
        DataInOutUtils.readFully(inputStream, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream inputStream, byte[] buffer, int offset, int length) throws IOException {
        int count;
        for (int bytesRead = 0; bytesRead < length; bytesRead += count) {
            count = inputStream.read(buffer, offset + bytesRead, length - bytesRead);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

