/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.rx.RxException;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTaskExecutor;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.Utilities;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.util.AbstractResponseHandler;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

class ClientSourceDeliveryCallback
implements Postman.Callback {
    private static final Logger LOGGER = Logger.getLogger(ClientSourceDeliveryCallback.class);
    private final RuntimeContext rc;

    public ClientSourceDeliveryCallback(RuntimeContext rc) {
        this.rc = rc;
    }

    @Override
    public void deliver(ApplicationMessage message) {
        if (!(message instanceof JaxwsApplicationMessage)) {
            throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1141_UNEXPECTED_MESSAGE_CLASS(message.getClass().getName(), JaxwsApplicationMessage.class.getName())))));
        }
        this.deliver((JaxwsApplicationMessage)JaxwsApplicationMessage.class.cast(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver(JaxwsApplicationMessage message) {
        LOGGER.entering(new Object[]{message});
        try {
            this.rc.sourceMessageHandler.attachAcknowledgementInfo(message);
            Packet outboundPacketCopy = message.getPacket().copy(true);
            this.rc.protocolHandler.appendSequenceHeader(outboundPacketCopy.getMessage(), message);
            this.rc.protocolHandler.appendAcknowledgementHeaders(outboundPacketCopy, message.getAcknowledgementData());
            AbstractResponseHandler responseCallback = outboundPacketCopy.expectReply == null ? new AmbiguousMepCallbackHandler(message, this.rc) : (outboundPacketCopy.expectReply != false ? new ReqRespMepCallbackHandler(message, this.rc) : new OneWayMepCallbackHandler(message, this.rc));
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finer("Selected Response callback class: " + responseCallback.getClass().getName());
            }
            this.rc.communicator.sendAsync(outboundPacketCopy, (Fiber.CompletionCallback)((Object)responseCallback));
        }
        finally {
            LOGGER.exiting();
        }
    }

    private static class AmbiguousMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final JaxwsApplicationMessage request;
        private final RuntimeContext rc;

        public AmbiguousMepCallbackHandler(JaxwsApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void onCompletion(Packet response) {
            block11: {
                try {
                    HaContext.initFrom(response);
                    if (response.getMessage() != null) {
                        JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                        this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                        this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                        this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                        if (message.getSequenceId() != null) {
                            try {
                                this.rc.destinationMessageHandler.registerMessage(message);
                                this.rc.destinationMessageHandler.putToDeliveryQueue(message);
                                return;
                            }
                            catch (DuplicateMessageRegistrationException ex) {
                                this.onCompletion(ex);
                                HaContext.clear();
                                return;
                            }
                        }
                    }
                    this.resumeParentFiber(response);
                    break block11;
                    {
                        catch (RxRuntimeException ex) {
                            this.onCompletion((Throwable)((Object)ex));
                            break block11;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    HaContext.clear();
                }
            }
        }

        @Override
        public void onCompletion(Throwable error) {
            if (Utilities.isResendPossible(error)) {
                RedeliveryTaskExecutor.INSTANCE.register(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(this.request.getNextResendCount(), this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
            } else {
                this.resumeParentFiber(error);
            }
        }
    }

    private static class OneWayMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final RuntimeContext rc;
        private final JaxwsApplicationMessage request;

        public OneWayMepCallbackHandler(JaxwsApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Packet response) {
            try {
                HaContext.initFrom(response);
                if (response.getMessage() != null) {
                    JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                    this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                    this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                    this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                    if (this.rc.configuration.getRuntimeVersion().protocolVersion.isFault(message.getWsaAction())) {
                        // empty if block
                    }
                }
                this.resumeParentFiber(response);
            }
            catch (RxRuntimeException ex) {
                this.onCompletion((Throwable)((Object)ex));
            }
            finally {
                HaContext.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Throwable error) {
            if (!Utilities.isResendPossible(error)) {
                this.resumeParentFiber(error);
                return;
            }
            int nextResendCount = this.request.getNextResendCount();
            if (!this.rc.configuration.getRmFeature().canRetransmitMessage(nextResendCount)) {
                this.resumeParentFiber(error);
                return;
            }
            try {
                HaContext.initFrom(this.request.getPacket());
                RedeliveryTaskExecutor.INSTANCE.register(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(nextResendCount, this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
            }
            finally {
                HaContext.clear();
            }
        }
    }

    private static class ReqRespMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final JaxwsApplicationMessage request;
        private final RuntimeContext rc;

        public ReqRespMepCallbackHandler(JaxwsApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Packet response) {
            try {
                HaContext.initFrom(response);
                if (response.getMessage() != null) {
                    JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                    this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                    this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                    this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                    if (this.rc.configuration.getRuntimeVersion().protocolVersion.isFault(message.getWsaAction())) {
                        // empty if block
                    }
                    if (message.getSequenceId() != null) {
                        this.rc.destinationMessageHandler.registerMessage(message);
                        this.rc.destinationMessageHandler.putToDeliveryQueue(message);
                    } else {
                        this.resumeParentFiber(response);
                    }
                } else {
                    int nextResendCount = this.request.getNextResendCount();
                    if (!this.rc.configuration.getRmFeature().canRetransmitMessage(nextResendCount)) {
                        this.resumeParentFiber((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1159_MAX_MESSAGE_RESEND_ATTEMPTS_REACHED())));
                        return;
                    }
                    RedeliveryTaskExecutor.INSTANCE.register(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(nextResendCount, this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
                }
            }
            catch (RxRuntimeException ex) {
                this.onCompletion((Throwable)((Object)ex));
            }
            catch (RxException ex) {
                this.onCompletion(ex);
            }
            finally {
                HaContext.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Throwable error) {
            if (Utilities.isResendPossible(error)) {
                int nextResendCount = this.request.getNextResendCount();
                if (!this.rc.configuration.getRmFeature().canRetransmitMessage(nextResendCount)) {
                    this.resumeParentFiber((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1159_MAX_MESSAGE_RESEND_ATTEMPTS_REACHED())));
                    return;
                }
                try {
                    HaContext.initFrom(this.request.getPacket());
                    RedeliveryTaskExecutor.INSTANCE.register(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(nextResendCount, this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
                }
                finally {
                    HaContext.clear();
                }
            } else {
                this.resumeParentFiber(error);
            }
        }
    }
}

