/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.tx.at;

import com.sun.xml.ws.api.tx.at.TransactionalFeature;
import com.sun.xml.ws.api.tx.at.WsatNamespace;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.xml.namespace.QName;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
@Documented
@WebServiceFeatureAnnotation(id="http://docs.oasis-open.org/ws-tx/", bean=TransactionalFeature.class)
public @interface Transactional {
    public boolean enabled() default true;

    public TransactionFlowType value() default TransactionFlowType.SUPPORTS;

    public Version version() default Version.DEFAULT;

    public static enum TransactionFlowType {
        MANDATORY,
        SUPPORTS,
        NEVER;

    }

    public static enum Version {
        WSAT10("wsat10", WsatNamespace.WSAT200410),
        WSAT11("wsat11", WsatNamespace.WSAT200606),
        WSAT12("wsat12", WsatNamespace.WSAT200606),
        DEFAULT("wsat", WsatNamespace.WSAT200606);

        public final QName qname;
        public final WsatNamespace namespaceVersion;

        private Version(String prefix, WsatNamespace namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            this.qname = new QName(namespaceVersion != null ? namespaceVersion.namespace : "", "ATAssertion", prefix);
        }

        public QName getQName() {
            return this.qname;
        }

        public static Version forNamespaceVersion(WsatNamespace nsVersion) {
            for (Version version : Version.values()) {
                if (version == WSAT11 || version == DEFAULT || version.namespaceVersion != nsVersion) continue;
                return version;
            }
            return DEFAULT;
        }

        public static Version forNamespaceUri(String ns) {
            for (Version version : Version.values()) {
                if (version == WSAT11 || version == DEFAULT || !version.qname.getNamespaceURI().equals(ns)) continue;
                return version;
            }
            return DEFAULT;
        }
    }
}

