/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.simple;

import java.io.File;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.engine.util.Format;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.buffer.BufferedNeuralDataSet;
import org.encog.neural.data.csv.CSVNeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.svm.SVMNetwork;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.neural.networks.training.svm.SVMTrain;
import org.encog.neural.pattern.FeedForwardPattern;
import org.encog.util.simple.TrainingDialog;

public final class EncogUtility {
    public static void convertCSV2Binary(File file, File file2, int n, int n2, boolean bl) {
        file2.delete();
        CSVNeuralDataSet cSVNeuralDataSet = new CSVNeuralDataSet(file.toString(), n, n2, false);
        BufferedNeuralDataSet bufferedNeuralDataSet = new BufferedNeuralDataSet(file2);
        bufferedNeuralDataSet.beginLoad(n, n2);
        for (NeuralDataPair neuralDataPair : cSVNeuralDataSet) {
            bufferedNeuralDataSet.add(neuralDataPair);
        }
        bufferedNeuralDataSet.endLoad();
    }

    public static void evaluate(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet) {
        for (NeuralDataPair neuralDataPair : neuralDataSet) {
            NeuralData neuralData = basicNetwork.compute(neuralDataPair.getInput());
            System.out.println("Input=" + EncogUtility.formatNeuralData(neuralDataPair.getInput()) + ", Actual=" + EncogUtility.formatNeuralData(neuralData) + ", Ideal=" + EncogUtility.formatNeuralData(neuralDataPair.getIdeal()));
        }
    }

    public static String formatNeuralData(NeuralData neuralData) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < neuralData.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(Format.formatDouble(neuralData.getData(i), 4));
        }
        return stringBuilder.toString();
    }

    public static BasicNetwork simpleFeedForward(int n, int n2, int n3, int n4, boolean bl) {
        FeedForwardPattern feedForwardPattern = new FeedForwardPattern();
        feedForwardPattern.setInputNeurons(n);
        feedForwardPattern.setOutputNeurons(n4);
        if (bl) {
            feedForwardPattern.setActivationFunction(new ActivationTANH());
        } else {
            feedForwardPattern.setActivationFunction(new ActivationSigmoid());
        }
        if (n2 > 0) {
            feedForwardPattern.addHiddenLayer(n2);
        }
        if (n3 > 0) {
            feedForwardPattern.addHiddenLayer(n3);
        }
        BasicNetwork basicNetwork = feedForwardPattern.generate();
        basicNetwork.reset();
        return basicNetwork;
    }

    public static void trainConsole(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, int n) {
        ResilientPropagation resilientPropagation = new ResilientPropagation(basicNetwork, neuralDataSet);
        resilientPropagation.setNumThreads(0);
        EncogUtility.trainConsole(resilientPropagation, basicNetwork, neuralDataSet, n);
    }

    public static void trainConsole(Train train, BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, int n) {
        long l;
        System.out.println("Beginning training...");
        long l2 = System.currentTimeMillis();
        do {
            train.iteration();
            long l3 = System.currentTimeMillis();
            long l4 = (l3 - l2) / 1000L;
            l = (long)n - l4 / 60L;
            int n2 = train.getIteration();
            System.out.println("Iteration #" + Format.formatInteger(n2) + " Error:" + Format.formatPercent(train.getError()) + " elapsed time = " + Format.formatTimeSpan((int)l4) + " time left = " + Format.formatTimeSpan((int)l * 60));
        } while (l > 0L);
        train.finishTraining();
    }

    public static void trainDialog(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet) {
        ResilientPropagation resilientPropagation = new ResilientPropagation(basicNetwork, neuralDataSet);
        resilientPropagation.setNumThreads(0);
        EncogUtility.trainDialog(resilientPropagation, basicNetwork, neuralDataSet);
    }

    public static void trainDialog(Train train, BasicNetwork basicNetwork, NeuralDataSet neuralDataSet) {
        TrainingDialog trainingDialog = new TrainingDialog();
        trainingDialog.setVisible(true);
        long l = System.currentTimeMillis();
        do {
            train.iteration();
            int n = train.getIteration();
            long l2 = System.currentTimeMillis();
            long l3 = (l2 - l) / 1000L;
            trainingDialog.setIterations(n);
            trainingDialog.setError(train.getError());
            trainingDialog.setTime((int)l3);
        } while (!trainingDialog.shouldStop());
        train.finishTraining();
        trainingDialog.dispose();
    }

    public static void trainToError(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, double d) {
        BasicTraining basicTraining = basicNetwork instanceof SVMNetwork ? new SVMTrain(basicNetwork, neuralDataSet) : new ResilientPropagation(basicNetwork, neuralDataSet);
        EncogUtility.trainToError(basicTraining, basicNetwork, neuralDataSet, d);
    }

    public static void trainToError(Train train, BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, double d) {
        int n = 1;
        System.out.println("Beginning training...");
        do {
            train.iteration();
            System.out.println("Iteration #" + Format.formatInteger(n) + " Error:" + Format.formatPercent(train.getError()) + " Target Error: " + Format.formatPercent(d));
            ++n;
        } while (train.getError() > d && !train.isTrainingDone());
        train.finishTraining();
    }

    private EncogUtility() {
    }
}

