/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.http;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLUtility {
    public static final int SPECIAL_CHAR_LIMIT = 255;
    public static final String INDEX_FILE = "index.html";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static URL constructURL(URL uRL, String string, boolean bl) throws IOException {
        URL uRL2 = new URL(uRL, string);
        String string2 = uRL2.getFile();
        String string3 = uRL2.getProtocol();
        String string4 = uRL2.getHost();
        int n = uRL2.getPort();
        String string5 = uRL2.getRef();
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n2 = stringBuilder.indexOf(" ");
        while (n2 != -1) {
            if (n2 != -1) {
                stringBuilder.replace(n2, n2 + 1, "%20");
            }
            n2 = stringBuilder.indexOf(" ");
        }
        string2 = stringBuilder.toString();
        uRL2 = string5 != null && !bl ? new URL(string3, string4, n, string2 + "#" + string5) : new URL(string3, string4, n, string2);
        return uRL2;
    }

    public static boolean containsInvalidURLCharacters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static String convertFilename(String string, URL uRL, boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string);
        StringBuilder stringBuilder2 = new StringBuilder(uRL.getHost().replace('.', '_'));
        if (uRL.getFile().length() == 0) {
            stringBuilder2.append('/');
        } else {
            stringBuilder2.append(uRL.getFile());
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) != File.separatorChar) {
            stringBuilder.append(File.separator);
        }
        int n2 = stringBuilder2.lastIndexOf("" + File.separatorChar);
        int n3 = stringBuilder2.lastIndexOf(".");
        if (stringBuilder2.charAt(stringBuilder2.length() - 1) != '/' && n2 > n3) {
            stringBuilder2.append(File.pathSeparatorChar);
            stringBuilder2.append(INDEX_FILE);
        }
        n2 = stringBuilder2.lastIndexOf("/");
        String string2 = "";
        if (n2 != -1) {
            string2 = stringBuilder2.substring(1 + n2);
            stringBuilder2 = stringBuilder2.replace(1 + n2, stringBuilder2.length(), "");
            if (string2.equals("")) {
                string2 = INDEX_FILE;
            }
        }
        int n4 = 0;
        do {
            if ((n = stringBuilder2.indexOf("/", n4)) == -1) continue;
            String string3 = stringBuilder2.substring(n4, n);
            stringBuilder.append(string3);
            stringBuilder.append(File.separator);
            if (bl) {
                File file = new File(stringBuilder.toString());
                file.mkdir();
            }
            n4 = n + 1;
        } while (n != -1);
        stringBuilder.append(string2.replace('?', '_'));
        return stringBuilder.toString();
    }

    private URLUtility() {
    }
}

