/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.csv;

import java.text.NumberFormat;
import java.util.Locale;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGIgnore;
import org.encog.util.csv.CSVError;

public class CSVFormat {
    public static final CSVFormat DECIMAL_POINT = new CSVFormat('.', ',');
    public static final CSVFormat DECIMAL_COMMA = new CSVFormat(',', ';');
    public static final CSVFormat ENGLISH = DECIMAL_POINT;
    public static final CSVFormat EG_FORMAT = DECIMAL_POINT;
    @EGAttribute
    private final char decimal;
    @EGAttribute
    private final char separator;
    @EGIgnore
    private final NumberFormat numberFormatter;

    public static char getDecimalCharacter() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        String string = numberFormat.format(0.5);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) continue;
            return c;
        }
        return '.';
    }

    public CSVFormat() {
        this('.', ',');
    }

    public CSVFormat(char c, char c2) {
        this.decimal = c;
        this.separator = c2;
        this.numberFormatter = c == '.' ? NumberFormat.getInstance(Locale.US) : (c == ',' ? NumberFormat.getInstance(Locale.FRANCE) : NumberFormat.getInstance());
    }

    public synchronized String format(double d, int n) {
        this.numberFormatter.setGroupingUsed(false);
        this.numberFormatter.setMaximumFractionDigits(n);
        return this.numberFormatter.format(d);
    }

    public char getDecimal() {
        return this.decimal;
    }

    public NumberFormat getNumberFormatter() {
        return this.numberFormatter;
    }

    public char getSeparator() {
        return this.separator;
    }

    public synchronized double parse(String string) {
        try {
            return this.numberFormatter.parse(string).doubleValue();
        }
        catch (Exception exception) {
            throw new CSVError("Error:" + exception.getMessage() + " on [" + string + "], decimal:" + this.decimal + ",sep: " + this.separator);
        }
    }
}

