/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.genome;

import java.util.ArrayList;
import java.util.List;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGIgnore;
import org.encog.solve.genetic.GeneticAlgorithm;
import org.encog.solve.genetic.GeneticError;
import org.encog.solve.genetic.genome.Chromosome;
import org.encog.solve.genetic.genome.Genome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicGenome
implements Genome {
    @EGAttribute
    private double adjustedScore;
    @EGAttribute
    private double amountToSpawn;
    private final List<Chromosome> chromosomes = new ArrayList<Chromosome>();
    @EGIgnore
    private GeneticAlgorithm geneticAlgorithm;
    @EGAttribute
    private long genomeID;
    @EGIgnore
    private Object organism;
    @EGAttribute
    private double score = 0.0;

    public BasicGenome(GeneticAlgorithm geneticAlgorithm) {
        this.geneticAlgorithm = geneticAlgorithm;
    }

    @Override
    public int calculateGeneCount() {
        int n = 0;
        for (Chromosome chromosome : this.chromosomes) {
            n += chromosome.getGenes().size();
        }
        return n;
    }

    @Override
    public int compareTo(Genome genome) {
        if (this.geneticAlgorithm.getCalculateScore().shouldMinimize()) {
            if (this.getScore() > genome.getScore()) {
                return 1;
            }
            return -1;
        }
        if (this.getScore() > genome.getScore()) {
            return -1;
        }
        return 1;
    }

    @Override
    public double getAdjustedScore() {
        return this.adjustedScore;
    }

    @Override
    public double getAmountToSpawn() {
        return this.amountToSpawn;
    }

    @Override
    public List<Chromosome> getChromosomes() {
        return this.chromosomes;
    }

    public GeneticAlgorithm getGeneticAlgorithm() {
        return this.geneticAlgorithm;
    }

    @Override
    public long getGenomeID() {
        return this.genomeID;
    }

    @Override
    public Object getOrganism() {
        return this.organism;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public void mate(Genome genome, Genome genome2, Genome genome3) {
        int n;
        int n2 = this.getChromosomes().size();
        if (n2 != (n = genome.getChromosomes().size())) {
            throw new GeneticError("Mother and father must have same chromosome count, Mother:" + n2 + ",Father:" + n);
        }
        for (int i = 0; i < n; ++i) {
            Chromosome chromosome = this.chromosomes.get(i);
            Chromosome chromosome2 = genome.getChromosomes().get(i);
            Chromosome chromosome3 = genome2.getChromosomes().get(i);
            Chromosome chromosome4 = genome3.getChromosomes().get(i);
            this.geneticAlgorithm.getCrossover().mate(chromosome, chromosome2, chromosome3, chromosome4);
            if (Math.random() < this.geneticAlgorithm.getMutationPercent()) {
                this.geneticAlgorithm.getMutate().performMutation(chromosome3);
            }
            if (!(Math.random() < this.geneticAlgorithm.getMutationPercent())) continue;
            this.geneticAlgorithm.getMutate().performMutation(chromosome4);
        }
        genome2.decode();
        genome3.decode();
        this.geneticAlgorithm.calculateScore(genome2);
        this.geneticAlgorithm.calculateScore(genome3);
    }

    @Override
    public void setAdjustedScore(double d) {
        this.adjustedScore = d;
    }

    @Override
    public void setAmountToSpawn(double d) {
        this.amountToSpawn = d;
    }

    public void setGeneticAlgorithm(GeneticAlgorithm geneticAlgorithm) {
        this.geneticAlgorithm = geneticAlgorithm;
    }

    @Override
    public void setGenomeID(long l) {
        this.genomeID = l;
    }

    public void setOrganism(Object object) {
        this.organism = object;
    }

    @Override
    public void setScore(double d) {
        this.score = d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[BasicGenome: score=");
        stringBuilder.append(this.getScore());
        return stringBuilder.toString();
    }
}

