/*
 * Decompiled with CFR 0.152.
 */
package org.encog.script;

import java.util.HashMap;
import java.util.Map;
import org.encog.persist.EncogMemoryCollection;
import org.encog.script.EncogScript;
import org.encog.script.EncogScriptEngine;
import org.encog.script.EncogScriptError;
import org.encog.script.IndividualEngineFactory;

public class EncogScriptEngineFactory {
    private static EncogScriptEngineFactory instance;
    private Map<String, IndividualEngineFactory> map = new HashMap<String, IndividualEngineFactory>();

    public static EncogScriptEngineFactory getInstance() {
        if (instance == null) {
            instance = new EncogScriptEngineFactory();
        }
        return instance;
    }

    public void registerIndividualEngineFactory(IndividualEngineFactory individualEngineFactory) {
        String string = individualEngineFactory.getName().toLowerCase();
        this.map.put(string, individualEngineFactory);
    }

    public EncogScriptEngine createEngine(EncogScript encogScript) {
        String string = encogScript.getLanguage().toLowerCase();
        IndividualEngineFactory individualEngineFactory = this.map.get(string);
        if (individualEngineFactory == null) {
            throw new EncogScriptError("Uknown language: " + encogScript.getLanguage());
        }
        if (encogScript.getCollection() instanceof EncogMemoryCollection) {
            return individualEngineFactory.create((EncogMemoryCollection)encogScript.getCollection());
        }
        return individualEngineFactory.create();
    }
}

