/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.neural.data.PropertyData;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;

public class PropertyDataPersistor
implements Persistor {
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_PROPERTY = "Property";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE = "value";
    private PropertyData propertyData;

    private void handleProperties(ReadXML readXML) {
        while (readXML.readToTag()) {
            if (readXML.is(TAG_PROPERTY, true)) {
                this.handleProperty(readXML);
                continue;
            }
            if (!readXML.is(TAG_PROPERTIES, false)) continue;
            break;
        }
    }

    private void handleProperty(ReadXML readXML) {
        String string = readXML.getTag().getAttributeValue(ATTRIBUTE_NAME);
        String string2 = readXML.getTag().getAttributeValue(ATTRIBUTE_VALUE);
        this.propertyData.set(string, string2);
    }

    public EncogPersistedObject load(ReadXML readXML) {
        String string = readXML.getTag().getAttributes().get(ATTRIBUTE_NAME);
        String string2 = readXML.getTag().getAttributes().get("description");
        this.propertyData = new PropertyData();
        this.propertyData.setName(string);
        this.propertyData.setDescription(string2);
        while (readXML.readToTag()) {
            if (readXML.is(TAG_PROPERTIES, true)) {
                this.handleProperties(readXML);
                continue;
            }
            if (!readXML.is("PropertyData", false)) continue;
            break;
        }
        return this.propertyData;
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        PropertyData propertyData = (PropertyData)encogPersistedObject;
        PersistorUtil.beginEncogObject("PropertyData", writeXML, encogPersistedObject, true);
        writeXML.beginTag(TAG_PROPERTIES);
        for (String string : propertyData.getData().keySet()) {
            writeXML.addAttribute(ATTRIBUTE_NAME, string);
            writeXML.addAttribute(ATTRIBUTE_VALUE, propertyData.get(string));
            writeXML.beginTag(TAG_PROPERTY);
            writeXML.endTag();
        }
        writeXML.endTag();
        writeXML.endTag();
    }
}

