/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.output.nominal;

import java.util.ArrayList;
import java.util.List;
import org.encog.mathutil.Equilateral;
import org.encog.normalize.input.InputField;
import org.encog.normalize.output.BasicOutputField;
import org.encog.normalize.output.nominal.NominalItem;
import org.encog.persist.annotations.EGIgnore;

public class OutputEquilateral
extends BasicOutputField {
    private final List<NominalItem> items = new ArrayList<NominalItem>();
    @EGIgnore
    private Equilateral equilateral;
    private int currentValue;
    private double high;
    private double low;

    public OutputEquilateral() {
    }

    public OutputEquilateral(double d, double d2) {
        this.high = d;
        this.low = d2;
    }

    public void addItem(InputField inputField, double d) {
        this.addItem(inputField, d + 0.1, d - 0.1);
    }

    public void addItem(InputField inputField, double d, double d2) {
        NominalItem nominalItem = new NominalItem(inputField, d, d2);
        this.items.add(nominalItem);
    }

    public double calculate(int n) {
        return this.equilateral.encode(this.currentValue)[n];
    }

    public Equilateral getEquilateral() {
        return this.equilateral;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public int getSubfieldCount() {
        return this.items.size() - 1;
    }

    public void rowInit() {
        for (int i = 0; i < this.items.size(); ++i) {
            NominalItem nominalItem = this.items.get(i);
            if (!nominalItem.isInRange()) continue;
            this.currentValue = i;
            break;
        }
        if (this.equilateral == null) {
            this.equilateral = new Equilateral(this.items.size(), this.high, this.low);
        }
    }
}

