/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationBiPolar;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.BoltzmannLogic;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltzmannPattern
implements NeuralNetworkPattern {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int neuronCount;
    private int annealCycles = 100;
    private int runCycles = 1000;
    private double temperature = 0.0;

    public void addHiddenLayer(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Boltzmann network has no hidden layers.");
        }
        throw new PatternError("A Boltzmann network has no hidden layers.");
    }

    public void clear() {
        this.neuronCount = 0;
    }

    public BasicNetwork generate() {
        BasicLayer basicLayer = new BasicLayer(new ActivationBiPolar(), true, this.neuronCount);
        BasicNetwork basicNetwork = new BasicNetwork(new BoltzmannLogic());
        basicNetwork.setProperty("ACYCLE", this.annealCycles);
        basicNetwork.setProperty("RCYCLE", this.runCycles);
        basicNetwork.setProperty("TEMPERATURE", this.temperature);
        basicNetwork.addLayer(basicLayer);
        basicLayer.addNext(basicLayer);
        basicLayer.setX(50);
        basicLayer.setY(50);
        basicNetwork.getStructure().finalizeStructure();
        basicNetwork.reset();
        return basicNetwork;
    }

    public int getAnnealCycles() {
        return this.annealCycles;
    }

    public int getRunCycles() {
        return this.runCycles;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Boltzmann network will use the BiPolar activation function, no activation function needs to be specified.");
        }
        throw new PatternError("A Boltzmann network will use the BiPolar activation function, no activation function needs to be specified.");
    }

    public void setAnnealCycles(int n) {
        this.annealCycles = n;
    }

    public void setInputNeurons(int n) {
        this.neuronCount = n;
    }

    public void setOutputNeurons(int n) {
        this.neuronCount = n;
    }

    public void setRunCycles(int n) {
        this.runCycles = n;
    }

    public void setTemperature(double d) {
        this.temperature = d;
    }
}

