/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.svm;

import java.util.Iterator;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_problem;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;

public class EncodeSVMProblem {
    private EncodeSVMProblem() {
    }

    private static long obtainTrainingLength(NeuralDataSet neuralDataSet) {
        if (neuralDataSet instanceof Indexable) {
            return ((Indexable)neuralDataSet).getRecordCount();
        }
        long l = 0L;
        Iterator iterator = neuralDataSet.iterator();
        while (iterator.hasNext()) {
            ++l;
        }
        return l;
    }

    public static svm_problem encode(NeuralDataSet neuralDataSet, int n) {
        svm_problem svm_problem2 = new svm_problem();
        svm_problem2.l = (int)EncodeSVMProblem.obtainTrainingLength(neuralDataSet);
        svm_problem2.y = new double[svm_problem2.l];
        svm_problem2.x = new svm_node[svm_problem2.l][neuralDataSet.getInputSize()];
        int n2 = 0;
        for (NeuralDataPair neuralDataPair : neuralDataSet) {
            NeuralData neuralData = neuralDataPair.getInput();
            NeuralData neuralData2 = neuralDataPair.getIdeal();
            svm_problem2.x[n2] = new svm_node[neuralData.size()];
            for (int i = 0; i < neuralData.size(); ++i) {
                svm_problem2.x[n2][i] = new svm_node();
                svm_problem2.x[n2][i].index = i + 1;
                svm_problem2.x[n2][i].value = neuralData.getData(i);
            }
            svm_problem2.y[n2] = neuralData2.getData(n);
            ++n2;
        }
        return svm_problem2;
    }
}

