/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy;

import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridStrategy
implements Strategy {
    public static final double DEFAULT_MIN_IMPROVEMENT = 1.0E-5;
    public static final int DEFAULT_TOLERATE_CYCLES = 10;
    public static final int DEFAULT_ALTERNATE_CYCLES = 5;
    private Train mainTrain;
    private final Train altTrain;
    private double lastImprovement;
    private double lastError;
    private boolean ready;
    private int lastHybrid;
    private final double minImprovement;
    private final int tolerateMinImprovement;
    private final int alternateCycles;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HybridStrategy(Train train) {
        this(train, 1.0E-5, 10, 5);
    }

    public HybridStrategy(Train train, double d, int n, int n2) {
        this.altTrain = train;
        this.ready = false;
        this.lastHybrid = 0;
        this.minImprovement = d;
        this.tolerateMinImprovement = n;
        this.alternateCycles = n2;
    }

    public void init(Train train) {
        this.mainTrain = train;
    }

    public void postIteration() {
        if (this.ready) {
            double d = this.mainTrain.getError();
            this.lastImprovement = (d - this.lastError) / this.lastError;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Last improvement: {}", (Object)this.lastImprovement);
            }
            if (this.lastImprovement > 0.0 || Math.abs(this.lastImprovement) < this.minImprovement) {
                ++this.lastHybrid;
                if (this.lastHybrid > this.tolerateMinImprovement) {
                    this.lastHybrid = 0;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Performing hybrid cycle");
                    }
                    for (int i = 0; i < this.alternateCycles; ++i) {
                        this.altTrain.iteration();
                    }
                }
            }
        } else {
            this.ready = true;
        }
    }

    public void preIteration() {
        this.lastError = this.mainTrain.getError();
    }
}

