/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy;

import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Greedy
implements Strategy {
    private Train train;
    private double lastError;
    private double[] lastNetwork;
    private boolean ready;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void init(Train train) {
        this.train = train;
        this.ready = false;
    }

    public void postIteration() {
        if (this.ready) {
            if (this.train.getError() > this.lastError) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Greedy strategy dropped last iteration.");
                }
                this.train.setError(this.lastError);
                NetworkCODEC.arrayToNetwork(this.lastNetwork, this.train.getNetwork());
            }
        } else {
            this.ready = true;
        }
    }

    public void preIteration() {
        BasicNetwork basicNetwork = this.train.getNetwork();
        if (basicNetwork != null) {
            this.lastError = this.train.getError();
            this.lastNetwork = NetworkCODEC.networkToArray(basicNetwork);
            this.train.setError(this.lastError);
        }
    }
}

