/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation;

import org.encog.EncogError;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.network.train.TrainFlatNetwork;
import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.EncogValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Propagation
extends BasicTraining {
    private final BasicNetwork network;
    private FlatNetwork currentFlatNetwork;
    private TrainFlatNetwork flatTraining;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Propagation(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet) {
        this.network = basicNetwork;
        this.setTraining(neuralDataSet);
    }

    public boolean canContinue() {
        return false;
    }

    public void finishTraining() {
        super.finishTraining();
        this.network.getStructure().updateFlatNetwork();
        this.flatTraining.finishTraining();
    }

    public FlatNetwork getCurrentFlatNetwork() {
        return this.currentFlatNetwork;
    }

    public TrainFlatNetwork getFlatTraining() {
        return this.flatTraining;
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    public int getNumThreads() {
        return this.flatTraining.getNumThreads();
    }

    public OpenCLTrainingProfile getProfile() {
        return null;
    }

    public boolean isValidResume(TrainingContinuation trainingContinuation) {
        return false;
    }

    public void iteration() {
        try {
            this.network.getStructure().updateFlatNetwork();
            this.preIteration();
            this.flatTraining.iteration();
            this.setError(this.flatTraining.getError());
            this.network.getStructure().setFlatUpdate(FlatUpdateNeeded.Unflatten);
            this.postIteration();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Training iteration done, error: " + this.getError());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            EncogValidate.validateNetworkForTraining(this.network, this.getTraining());
            throw new EncogError(arrayIndexOutOfBoundsException);
        }
    }

    public void iteration(int n) {
        try {
            this.preIteration();
            this.flatTraining.iteration(n);
            this.setIteration(this.flatTraining.getIteration());
            this.setError(this.flatTraining.getError());
            this.network.getStructure().setFlatUpdate(FlatUpdateNeeded.Unflatten);
            this.postIteration();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Training iterations done, error: " + this.getError());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            EncogValidate.validateNetworkForTraining(this.network, this.getTraining());
            throw new EncogError(arrayIndexOutOfBoundsException);
        }
    }

    public TrainingContinuation pause() {
        throw new TrainingError("This training type does not support pause.");
    }

    public void resume(TrainingContinuation trainingContinuation) {
        throw new TrainingError("This training type does not support resume.");
    }

    public void setFlatTraining(TrainFlatNetwork trainFlatNetwork) {
        this.flatTraining = trainFlatNetwork;
    }

    public void setNumThreads(int n) {
        this.flatTraining.setNumThreads(n);
    }
}

