/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.genetic;

import org.encog.mathutil.randomize.Randomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.CalculateScore;
import org.encog.neural.networks.training.genetic.GeneticScoreAdapter;
import org.encog.neural.networks.training.genetic.NeuralGenome;
import org.encog.solve.genetic.GeneticAlgorithm;
import org.encog.solve.genetic.crossover.Splice;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.mutate.MutatePerturb;
import org.encog.solve.genetic.population.BasicPopulation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralGeneticAlgorithm
extends BasicTraining {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NeuralGeneticAlgorithmHelper genetic = new NeuralGeneticAlgorithmHelper();

    public NeuralGeneticAlgorithm(BasicNetwork basicNetwork, Randomizer randomizer, CalculateScore calculateScore, int n, double d, double d2) {
        this.genetic.setCalculateScore(new GeneticScoreAdapter(calculateScore));
        BasicPopulation basicPopulation = new BasicPopulation(n);
        this.getGenetic().setMutationPercent(d);
        this.getGenetic().setMatingPopulation(d2 * 2.0);
        this.getGenetic().setPercentToMate(d2);
        this.getGenetic().setCrossover(new Splice(basicNetwork.getStructure().calculateSize() / 3));
        this.getGenetic().setMutate(new MutatePerturb(4.0));
        this.getGenetic().setPopulation(basicPopulation);
        for (int i = 0; i < basicPopulation.getPopulationSize(); ++i) {
            BasicNetwork basicNetwork2 = (BasicNetwork)basicNetwork.clone();
            randomizer.randomize(basicNetwork2);
            NeuralGenome neuralGenome = new NeuralGenome(this, basicNetwork2);
            this.getGenetic().calculateScore(neuralGenome);
            this.getGenetic().getPopulation().add(neuralGenome);
        }
        basicPopulation.sort();
    }

    public NeuralGeneticAlgorithmHelper getGenetic() {
        return this.genetic;
    }

    public BasicNetwork getNetwork() {
        return this.getGenetic().getNetwork();
    }

    public void iteration() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Performing Genetic iteration.");
        }
        this.preIteration();
        this.getGenetic().iteration();
        this.setError(this.getGenetic().getError());
        this.postIteration();
    }

    public void setGenetic(NeuralGeneticAlgorithmHelper neuralGeneticAlgorithmHelper) {
        this.genetic = neuralGeneticAlgorithmHelper;
    }

    public class NeuralGeneticAlgorithmHelper
    extends GeneticAlgorithm {
        public double getError() {
            Genome genome = this.getPopulation().getBest();
            return genome.getScore();
        }

        public BasicNetwork getNetwork() {
            Genome genome = this.getPopulation().getBest();
            return (BasicNetwork)genome.getOrganism();
        }
    }
}

