/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.performers;

import java.util.concurrent.atomic.AtomicBoolean;
import org.encog.engine.concurrency.EngineConcurrency;
import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.util.Stopwatch;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.training.concurrent.ConcurrentTrainingManager;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformer;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformerOpenCL;
import org.encog.neural.networks.training.concurrent.performers.PerformerTask;

public class ConcurrentTrainingPerformerCPU
implements ConcurrentTrainingPerformer,
Runnable {
    private final AtomicBoolean ready = new AtomicBoolean(true);
    private TrainingJob currentJob;
    private ConcurrentTrainingManager manager;
    private int number;

    public ConcurrentTrainingPerformerCPU(int n) {
        this.number = n;
    }

    public void perform(TrainingJob trainingJob) {
        if (!this.ready.get()) {
            throw new NeuralNetworkError("Performer is already performing a job.");
        }
        this.ready.set(false);
        this.currentJob = trainingJob;
        PerformerTask performerTask = new PerformerTask(this);
        EngineConcurrency.getInstance().processTask(performerTask);
    }

    public boolean ready() {
        return this.ready.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Stopwatch stopwatch = new Stopwatch();
        try {
            Object object;
            stopwatch.start();
            OpenCLTrainingProfile openCLTrainingProfile = null;
            if (this instanceof ConcurrentTrainingPerformerOpenCL) {
                object = ((ConcurrentTrainingPerformerOpenCL)this).getDevice();
                openCLTrainingProfile = new OpenCLTrainingProfile((EncogCLDevice)object, this.currentJob.getLocalRatio(), this.currentJob.getGlobalRatio(), this.currentJob.getSegmentationRatio());
            }
            this.currentJob.createTrainer(openCLTrainingProfile, this.manager.isSingleThreaded());
            object = this.currentJob.getTrain();
            int n = 1;
            while (this.currentJob.shouldContinue()) {
                object.iteration(this.currentJob.getIterationsPer());
                ++n;
            }
            stopwatch.stop();
        }
        catch (Throwable throwable) {
            this.currentJob.setError(throwable);
        }
        finally {
            this.ready.set(true);
            this.manager.jobDone(stopwatch.getElapsedMilliseconds(), this);
        }
    }

    public String toString() {
        return "[CPU-Performer: " + this.number + "]";
    }

    public int getNumber() {
        return this.number;
    }

    public ConcurrentTrainingManager getManager() {
        return this.manager;
    }

    public void setManager(ConcurrentTrainingManager concurrentTrainingManager) {
        this.manager = concurrentTrainingManager;
    }
}

