/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;

public class RPROPJob
extends TrainingJob {
    private double initialUpdate;
    private double maxStep;

    public RPROPJob(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, boolean bl) {
        this(basicNetwork, neuralDataSet, bl, 0.1, 50.0, 1.0, 1, 1.0, 1);
    }

    public RPROPJob(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, boolean bl, double d, int n, double d2, int n2) {
        this(basicNetwork, neuralDataSet, bl, 0.1, 50.0, d, n, d2, n2);
    }

    public RPROPJob(BasicNetwork basicNetwork, NeuralDataSet neuralDataSet, boolean bl, double d, double d2, double d3, int n, double d4, int n2) {
        super(basicNetwork, neuralDataSet, bl);
        this.initialUpdate = d;
        this.maxStep = d2;
        this.setLocalRatio(d3);
        this.setGlobalRatio(n);
        this.setSegmentationRatio(d4);
        this.setIterationsPer(n2);
    }

    public void createTrainer(OpenCLTrainingProfile openCLTrainingProfile, boolean bl) {
        ResilientPropagation resilientPropagation = new ResilientPropagation(this.getNetwork(), this.getTraining(), openCLTrainingProfile, this.getInitialUpdate(), this.getMaxStep());
        if (bl) {
            resilientPropagation.setNumThreads(1);
        } else {
            resilientPropagation.setNumThreads(0);
        }
        for (Strategy strategy : this.getStrategies()) {
            resilientPropagation.addStrategy(strategy);
        }
        this.setTrain(resilientPropagation);
    }

    public double getInitialUpdate() {
        return this.initialUpdate;
    }

    public double getMaxStep() {
        return this.maxStep;
    }

    public void setInitialUpdate(double d) {
        this.initialUpdate = d;
    }

    public void setMaxStep(double d) {
        this.maxStep = d;
    }
}

