/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.competitive;

import org.encog.engine.util.BoundMath;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.competitive.CompetitiveTraining;

public class BestMatchingUnit {
    private final CompetitiveTraining training;
    private double worstDistance;

    public BestMatchingUnit(CompetitiveTraining competitiveTraining) {
        this.training = competitiveTraining;
    }

    public int calculateBMU(Synapse synapse, NeuralData neuralData) {
        int n = 0;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.training.getOutputNeuronCount(); ++i) {
            double d2 = this.calculateEuclideanDistance(synapse, neuralData, i);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        if (d > this.worstDistance) {
            this.worstDistance = d;
        }
        return n;
    }

    public double calculateEuclideanDistance(Synapse synapse, NeuralData neuralData, int n) {
        double d = 0.0;
        for (int i = 0; i < neuralData.size(); ++i) {
            double d2 = neuralData.getData(i) - synapse.getMatrix().get(i, n);
            d += d2 * d2;
        }
        return BoundMath.sqrt(d);
    }

    public double getWorstDistance() {
        return this.worstDistance;
    }

    public void reset() {
        this.worstDistance = Double.MIN_VALUE;
    }
}

