/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.anneal;

import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.CalculateScore;
import org.encog.neural.networks.training.anneal.NeuralSimulatedAnnealingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralSimulatedAnnealing
extends BasicTraining {
    public static final double CUT = 0.5;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BasicNetwork network;
    private final NeuralSimulatedAnnealingHelper anneal;
    private final CalculateScore calculateScore;

    public NeuralSimulatedAnnealing(BasicNetwork basicNetwork, CalculateScore calculateScore, double d, double d2, int n) {
        this.network = basicNetwork;
        this.calculateScore = calculateScore;
        this.anneal = new NeuralSimulatedAnnealingHelper(this);
        this.anneal.setTemperature(d);
        this.anneal.setStartTemperature(d);
        this.anneal.setStopTemperature(d2);
        this.anneal.setCycles(n);
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    public void iteration() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Performing Simulated Annealing iteration.");
        }
        this.preIteration();
        this.anneal.iteration();
        this.setError(this.anneal.calculateScore());
        this.postIteration();
    }

    public double[] getArray() {
        return NetworkCODEC.networkToArray(this.network);
    }

    public double[] getArrayCopy() {
        return this.getArray();
    }

    public void putArray(double[] dArray) {
        NetworkCODEC.arrayToNetwork(dArray, this.network);
    }

    public void randomize() {
        double[] dArray = NetworkCODEC.networkToArray(this.network);
        for (int i = 0; i < dArray.length; ++i) {
            double d = 0.5 - Math.random();
            d /= this.anneal.getStartTemperature();
            dArray[i] = dArray[i] + (d *= this.anneal.getTemperature());
        }
        NetworkCODEC.arrayToNetwork(dArray, this.network);
    }

    public CalculateScore getCalculateScore() {
        return this.calculateScore;
    }
}

