/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse;

import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.BasicSynapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.OneToOneSynapsePersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneToOneSynapse
extends BasicSynapse {
    private static final long serialVersionUID = -8098797476221631089L;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public OneToOneSynapse() {
    }

    public OneToOneSynapse(Layer layer, Layer layer2) {
        if (layer.getNeuronCount() != layer2.getNeuronCount()) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("From and to layers must have the same number of neurons.");
            }
            throw new NeuralNetworkError("From and to layers must have the same number of neurons.");
        }
        this.setFromLayer(layer);
        this.setToLayer(layer2);
    }

    public Object clone() {
        OneToOneSynapse oneToOneSynapse = new OneToOneSynapse(this.getFromLayer(), this.getToLayer());
        return oneToOneSynapse;
    }

    public NeuralData compute(NeuralData neuralData) {
        return neuralData;
    }

    public Persistor createPersistor() {
        return new OneToOneSynapsePersistor();
    }

    public Matrix getMatrix() {
        return null;
    }

    public int getMatrixSize() {
        return 0;
    }

    public SynapseType getType() {
        return SynapseType.OneToOne;
    }

    public boolean isTeachable() {
        return false;
    }

    public void setMatrix(Matrix matrix) {
        throw new NeuralNetworkError("Can't set the matrix for a OneToOneSynapse");
    }
}

