/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;

public class CalculateDepth {
    private final Map<Layer, Integer> depths = new HashMap<Layer, Integer>();
    private final BasicNetwork network;
    private final Layer outputLayer;

    public CalculateDepth(BasicNetwork basicNetwork) {
        this.network = basicNetwork;
        this.outputLayer = basicNetwork.getLayer("OUTPUT");
        this.calculate(0, this.outputLayer);
    }

    private void calculate(int n, Layer layer) {
        if (this.depths.containsKey(layer)) {
            int n2 = this.depths.get(layer);
            if (n > n2) {
                this.depths.put(layer, n);
            }
        } else {
            this.depths.put(layer, n);
        }
        Collection<Layer> collection = this.network.getStructure().getPreviousLayers(layer);
        for (Layer layer2 : collection) {
            if (this.depths.containsKey(layer2)) continue;
            this.calculate(n + 1, layer2);
        }
    }

    public int getDepth(Layer layer) {
        if (!this.depths.containsKey(layer)) {
            return -1;
        }
        return this.depths.get(layer);
    }
}

