/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.temporal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.data.temporal.TemporalDataDescription;
import org.encog.neural.data.temporal.TemporalError;
import org.encog.neural.data.temporal.TemporalPoint;
import org.encog.util.time.TimeSpan;
import org.encog.util.time.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporalNeuralDataSet
extends BasicNeuralDataSet {
    private static final long serialVersionUID = 7846736117000051687L;
    public static final String ADD_NOT_SUPPORTED = "Direct adds to the temporal dataset are not supported.  Add TemporalPoint objects and call generate.";
    private final List<TemporalDataDescription> descriptions = new ArrayList<TemporalDataDescription>();
    private final List<TemporalPoint> points = new ArrayList<TemporalPoint>();
    private int inputWindowSize;
    private int predictWindowSize;
    private int lowSequence;
    private int highSequence;
    private int desiredSetSize;
    private int inputNeuronCount;
    private int outputNeuronCount;
    private Date startingPoint;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TimeUnit sequenceGrandularity;

    public TemporalNeuralDataSet(int n, int n2) {
        this.inputWindowSize = n;
        this.predictWindowSize = n2;
        this.lowSequence = Integer.MIN_VALUE;
        this.highSequence = Integer.MAX_VALUE;
        this.desiredSetSize = Integer.MAX_VALUE;
        this.startingPoint = null;
        this.sequenceGrandularity = TimeUnit.DAYS;
    }

    @Override
    public void add(NeuralData neuralData) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new TemporalError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralData neuralData, NeuralData neuralData2) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new TemporalError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralDataPair neuralDataPair) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new TemporalError(ADD_NOT_SUPPORTED);
    }

    public void addDescription(TemporalDataDescription temporalDataDescription) {
        if (this.points.size() > 0) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Can't add anymore descriptions, there are already temporal points defined.");
            }
            throw new TemporalError("Can't add anymore descriptions, there are already temporal points defined.");
        }
        int n = this.descriptions.size();
        temporalDataDescription.setIndex(n);
        this.descriptions.add(temporalDataDescription);
        this.calculateNeuronCounts();
    }

    public int calculateActualSetSize() {
        int n = this.calculatePointsInRange();
        n = Math.min(this.desiredSetSize, n);
        return n;
    }

    public void calculateNeuronCounts() {
        this.inputNeuronCount = 0;
        this.outputNeuronCount = 0;
        for (TemporalDataDescription temporalDataDescription : this.descriptions) {
            if (temporalDataDescription.isInput()) {
                this.inputNeuronCount += this.inputWindowSize;
            }
            if (!temporalDataDescription.isPredict()) continue;
            this.outputNeuronCount += this.predictWindowSize;
        }
    }

    public int calculatePointsInRange() {
        int n = 0;
        for (TemporalPoint temporalPoint : this.points) {
            if (!this.isPointInRange(temporalPoint)) continue;
            ++n;
        }
        return n;
    }

    public int calculateStartIndex() {
        for (int i = 0; i < this.points.size(); ++i) {
            TemporalPoint temporalPoint = this.points.get(i);
            if (!this.isPointInRange(temporalPoint)) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.descriptions.clear();
        this.points.clear();
        this.getData().clear();
    }

    public TemporalPoint createPoint(Date date) {
        int n = this.getSequenceFromDate(date);
        TemporalPoint temporalPoint = new TemporalPoint(this.descriptions.size());
        temporalPoint.setSequence(n);
        this.points.add(temporalPoint);
        return temporalPoint;
    }

    public TemporalPoint createPoint(int n) {
        TemporalPoint temporalPoint = new TemporalPoint(this.descriptions.size());
        temporalPoint.setSequence(n);
        this.points.add(temporalPoint);
        return temporalPoint;
    }

    private double formatData(TemporalDataDescription temporalDataDescription, int n) {
        double[] dArray = new double[1];
        switch (temporalDataDescription.getType()) {
            case DELTA_CHANGE: {
                dArray[0] = this.getDataDeltaChange(temporalDataDescription, n);
                break;
            }
            case PERCENT_CHANGE: {
                dArray[0] = this.getDataPercentChange(temporalDataDescription, n);
                break;
            }
            case RAW: {
                dArray[0] = this.getDataRAW(temporalDataDescription, n);
                break;
            }
            default: {
                throw new TemporalError("Unsupported data type.");
            }
        }
        if (temporalDataDescription.getActivationFunction() != null) {
            temporalDataDescription.getActivationFunction().activationFunction(dArray, 0, dArray.length);
        }
        return dArray[0];
    }

    public void generate() {
        this.sortPoints();
        int n = this.calculateStartIndex() + 1;
        int n2 = this.calculateActualSetSize();
        int n3 = n + n2 - this.predictWindowSize - this.inputWindowSize;
        for (int i = n; i < n3; ++i) {
            BasicNeuralData basicNeuralData = this.generateInputNeuralData(i);
            BasicNeuralData basicNeuralData2 = this.generateOutputNeuralData(i + this.inputWindowSize);
            BasicNeuralDataPair basicNeuralDataPair = new BasicNeuralDataPair(basicNeuralData, basicNeuralData2);
            super.add(basicNeuralDataPair);
        }
    }

    public BasicNeuralData generateInputNeuralData(int n) {
        if (n + this.inputWindowSize > this.points.size()) {
            throw new TemporalError("Can't generate input temporal data beyond the end of provided data.");
        }
        BasicNeuralData basicNeuralData = new BasicNeuralData(this.inputNeuronCount);
        int n2 = 0;
        for (int i = 0; i < this.inputWindowSize; ++i) {
            int n3 = 0;
            for (TemporalDataDescription temporalDataDescription : this.descriptions) {
                if (temporalDataDescription.isInput()) {
                    basicNeuralData.setData(n2++, this.formatData(temporalDataDescription, n + i));
                }
                ++n3;
            }
        }
        return basicNeuralData;
    }

    public BasicNeuralData generateOutputNeuralData(int n) {
        if (n + this.predictWindowSize > this.points.size()) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Can't generate prediction temporal data beyond the end of provided data.");
            }
            throw new TemporalError("Can't generate prediction temporal data beyond the end of provided data.");
        }
        BasicNeuralData basicNeuralData = new BasicNeuralData(this.outputNeuronCount);
        int n2 = 0;
        for (int i = 0; i < this.predictWindowSize; ++i) {
            int n3 = 0;
            for (TemporalDataDescription temporalDataDescription : this.descriptions) {
                if (temporalDataDescription.isPredict()) {
                    basicNeuralData.setData(n2++, this.formatData(temporalDataDescription, n + i));
                }
                ++n3;
            }
        }
        return basicNeuralData;
    }

    private double getDataDeltaChange(TemporalDataDescription temporalDataDescription, int n) {
        if (n == 0) {
            return 0.0;
        }
        TemporalPoint temporalPoint = this.points.get(n);
        TemporalPoint temporalPoint2 = this.points.get(n - 1);
        return temporalPoint.getData(temporalDataDescription.getIndex()) - temporalPoint2.getData(temporalDataDescription.getIndex());
    }

    private double getDataPercentChange(TemporalDataDescription temporalDataDescription, int n) {
        if (n == 0) {
            return 0.0;
        }
        TemporalPoint temporalPoint = this.points.get(n);
        TemporalPoint temporalPoint2 = this.points.get(n - 1);
        double d = temporalPoint.getData(temporalDataDescription.getIndex());
        double d2 = temporalPoint2.getData(temporalDataDescription.getIndex());
        return (d - d2) / d2;
    }

    private double getDataRAW(TemporalDataDescription temporalDataDescription, int n) {
        TemporalPoint temporalPoint = this.points.get(n - 1);
        return temporalPoint.getData(temporalDataDescription.getIndex());
    }

    public List<TemporalDataDescription> getDescriptions() {
        return this.descriptions;
    }

    public int getDesiredSetSize() {
        return this.desiredSetSize;
    }

    public int getHighSequence() {
        return this.highSequence;
    }

    public int getInputNeuronCount() {
        return this.inputNeuronCount;
    }

    public int getInputWindowSize() {
        return this.inputWindowSize;
    }

    public int getLowSequence() {
        return this.lowSequence;
    }

    public int getOutputNeuronCount() {
        return this.outputNeuronCount;
    }

    public List<TemporalPoint> getPoints() {
        return this.points;
    }

    public int getPredictWindowSize() {
        return this.predictWindowSize;
    }

    public int getSequenceFromDate(Date date) {
        int n;
        if (this.startingPoint != null) {
            TimeSpan timeSpan = new TimeSpan(this.startingPoint, date);
            n = (int)timeSpan.getSpan(this.sequenceGrandularity);
        } else {
            this.startingPoint = date;
            n = 0;
        }
        return n;
    }

    public TimeUnit getSequenceGrandularity() {
        return this.sequenceGrandularity;
    }

    public Date getStartingPoint() {
        return this.startingPoint;
    }

    public boolean isPointInRange(TemporalPoint temporalPoint) {
        return temporalPoint.getSequence() >= this.getLowSequence() && temporalPoint.getSequence() <= this.getHighSequence();
    }

    public void setDesiredSetSize(int n) {
        this.desiredSetSize = n;
    }

    public void setHighSequence(int n) {
        this.highSequence = n;
    }

    public void setInputWindowSize(int n) {
        this.inputWindowSize = n;
    }

    public void setLowSequence(int n) {
        this.lowSequence = n;
    }

    public void setPredictWindowSize(int n) {
        this.predictWindowSize = n;
    }

    public void setSequenceGrandularity(TimeUnit timeUnit) {
        this.sequenceGrandularity = timeUnit;
    }

    public void setStartingPoint(Date date) {
        this.startingPoint = date;
    }

    public void sortPoints() {
        Collections.sort(this.points);
    }
}

