/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.market.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.encog.neural.data.market.MarketDataType;
import org.encog.neural.data.market.TickerSymbol;
import org.encog.neural.data.market.loader.LoadedMarketData;
import org.encog.neural.data.market.loader.LoaderError;
import org.encog.neural.data.market.loader.MarketLoader;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.http.FormUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooFinanceLoader
implements MarketLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private URL buildURL(TickerSymbol tickerSymbol, Date date, Date date2) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FormUtility formUtility = new FormUtility(byteArrayOutputStream, null);
        formUtility.add("s", tickerSymbol.getSymbol().toUpperCase());
        formUtility.add("a", "" + calendar.get(2));
        formUtility.add("b", "" + calendar.get(5));
        formUtility.add("c", "" + calendar.get(1));
        formUtility.add("d", "" + calendar2.get(2));
        formUtility.add("e", "" + calendar2.get(5));
        formUtility.add("f", "" + calendar2.get(1));
        formUtility.add("g", "d");
        formUtility.add("ignore", ".csv");
        ((OutputStream)byteArrayOutputStream).close();
        String string = "http://ichart.finance.yahoo.com/table.csv?" + ((Object)byteArrayOutputStream).toString();
        return new URL(string);
    }

    @Override
    public Collection<LoadedMarketData> load(TickerSymbol tickerSymbol, Set<MarketDataType> set, Date date, Date date2) {
        try {
            ArrayList<LoadedMarketData> arrayList = new ArrayList<LoadedMarketData>();
            URL uRL = this.buildURL(tickerSymbol, date, date2);
            InputStream inputStream = uRL.openStream();
            ReadCSV readCSV = new ReadCSV(inputStream, true, CSVFormat.ENGLISH);
            while (readCSV.next()) {
                Date date3 = readCSV.getDate("date");
                double d = readCSV.getDouble("adj close");
                double d2 = readCSV.getDouble("open");
                double d3 = readCSV.getDouble("close");
                double d4 = readCSV.getDouble("high");
                double d5 = readCSV.getDouble("low");
                double d6 = readCSV.getDouble("volume");
                LoadedMarketData loadedMarketData = new LoadedMarketData(date3, tickerSymbol);
                loadedMarketData.setData(MarketDataType.ADJUSTED_CLOSE, d);
                loadedMarketData.setData(MarketDataType.OPEN, d2);
                loadedMarketData.setData(MarketDataType.CLOSE, d3);
                loadedMarketData.setData(MarketDataType.HIGH, d4);
                loadedMarketData.setData(MarketDataType.LOW, d5);
                loadedMarketData.setData(MarketDataType.OPEN, d2);
                loadedMarketData.setData(MarketDataType.VOLUME, d6);
                arrayList.add(loadedMarketData);
            }
            readCSV.close();
            inputStream.close();
            return arrayList;
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)iOException);
            }
            throw new LoaderError(iOException);
        }
    }
}

