/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.image;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.data.image.ImageNeuralData;
import org.encog.util.downsample.Downsample;

public class ImageNeuralDataSet
extends BasicNeuralDataSet {
    private static final long serialVersionUID = 3368190842312829906L;
    public static final String MUST_USE_IMAGE = "This data set only supports ImageNeuralData or Image objects.";
    private final Downsample downsampler;
    private int height;
    private int width;
    private final boolean findBounds;
    private final double hi;
    private final double lo;

    public ImageNeuralDataSet(Downsample downsample, boolean bl, double d, double d2) {
        this.downsampler = downsample;
        this.findBounds = bl;
        this.height = -1;
        this.width = -1;
        this.hi = d;
        this.lo = d2;
    }

    public void add(NeuralData neuralData) {
        if (!(neuralData instanceof ImageNeuralData)) {
            throw new NeuralNetworkError(MUST_USE_IMAGE);
        }
        super.add(neuralData);
    }

    public void add(NeuralData neuralData, NeuralData neuralData2) {
        if (!(neuralData instanceof ImageNeuralData)) {
            throw new NeuralNetworkError(MUST_USE_IMAGE);
        }
        super.add(neuralData, neuralData2);
    }

    public void add(NeuralDataPair neuralDataPair) {
        if (!(neuralDataPair.getInput() instanceof ImageNeuralData)) {
            throw new NeuralNetworkError(MUST_USE_IMAGE);
        }
        super.add(neuralDataPair);
    }

    public void downsample(int n, int n2) {
        this.height = n;
        this.width = n2;
        for (NeuralDataPair neuralDataPair : this) {
            if (!(neuralDataPair.getInput() instanceof ImageNeuralData)) {
                throw new NeuralNetworkError("Invalid class type found in ImageNeuralDataSet, only ImageNeuralData items are allowed.");
            }
            ImageNeuralData imageNeuralData = (ImageNeuralData)neuralDataPair.getInput();
            imageNeuralData.downsample(this.downsampler, this.findBounds, n, n2, this.hi, this.lo);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

