/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

import java.io.Serializable;
import org.encog.mathutil.matrices.MatrixError;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.mathutil.matrices.decomposition.LUDecomposition;
import org.encog.mathutil.matrices.decomposition.QRDecomposition;
import org.encog.persist.BasicPersistedSubObject;
import org.encog.persist.Persistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matrix
extends BasicPersistedSubObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7977897210426471675L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(Matrix.class);
    private final double[][] matrix;

    public static Matrix createColumnMatrix(double[] dArray) {
        double[][] dArray2 = new double[dArray.length][1];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i][0] = dArray[i];
        }
        return new Matrix(dArray2);
    }

    public static Matrix createRowMatrix(double[] dArray) {
        double[][] dArray2 = new double[1][dArray.length];
        System.arraycopy(dArray, 0, dArray2[0], 0, dArray.length);
        return new Matrix(dArray2);
    }

    public Matrix(boolean[][] blArray) {
        this.matrix = new double[blArray.length][blArray[0].length];
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                if (blArray[i][j]) {
                    this.set(i, j, 1.0);
                    continue;
                }
                this.set(i, j, -1.0);
            }
        }
    }

    public Matrix(double[][] dArray) {
        this.matrix = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                this.set(i, j, dArray[i][j]);
            }
        }
    }

    public Matrix(int n, int n2) {
        this.matrix = new double[n][n2];
    }

    public void add(int n, int n2, double d) {
        this.validate(n, n2);
        double d2 = this.matrix[n][n2] + d;
        this.set(n, n2, d2);
    }

    public void add(Matrix matrix) {
        double[][] dArray = matrix.getData();
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                double[] dArray2 = this.matrix[i];
                int n = j;
                dArray2[n] = dArray2[n] + dArray[i][j];
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                this.matrix[i][j] = 0.0;
            }
        }
    }

    public Matrix clone() {
        return new Matrix(this.matrix);
    }

    public Persistor createPersistor() {
        return null;
    }

    public boolean equals(Matrix matrix, int n) {
        if (n < 0) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Precision can't be a negative number.");
            }
            throw new MatrixError("Precision can't be a negative number.");
        }
        double d = Math.pow(10.0, n);
        if (Double.isInfinite(d) || d > 9.223372036854776E18) {
            String string = "Precision of " + n + " decimal places is not supported.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        int n2 = (int)Math.pow(10.0, n);
        double[][] dArray = matrix.getData();
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                if ((long)(this.matrix[i][j] * (double)n2) == (long)(dArray[i][j] * (double)n2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix) {
            return this.equals((Matrix)object, 10);
        }
        return false;
    }

    public int fromPackedArray(Double[] doubleArray, int n) {
        int n2 = n;
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                this.matrix[i][j] = doubleArray[n2++];
            }
        }
        return n2;
    }

    public double get(int n, int n2) {
        this.validate(n, n2);
        return this.matrix[n][n2];
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.getRows()][this.getCols()];
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                dArray[i][j] = this.matrix[i][j];
            }
        }
        return dArray;
    }

    public Matrix getCol(int n) {
        if (n > this.getCols()) {
            String string = "Can't get column #" + n + " because it does not exist.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        double[][] dArray = new double[this.getRows()][1];
        for (int i = 0; i < this.getRows(); ++i) {
            dArray[i][0] = this.matrix[i][n];
        }
        return new Matrix(dArray);
    }

    public int getCols() {
        return this.matrix[0].length;
    }

    public double[][] getData() {
        return this.matrix;
    }

    public Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.getData();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    dArray[i - n][j - n3] = this.matrix[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MatrixError("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int n, int n2, int[] nArray) {
        Matrix matrix = new Matrix(n2 - n + 1, nArray.length);
        double[][] dArray = matrix.getData();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    dArray[i - n][j] = this.matrix[i][nArray[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MatrixError("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int n, int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        double[][] dArray = matrix.getData();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    dArray[i][j - n] = this.matrix[nArray[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        double[][] dArray = matrix.getData();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    dArray[i][j] = this.matrix[nArray[i]][nArray2[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MatrixError("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getRow(int n) {
        if (n > this.getRows()) {
            String string = "Can't get row #" + n + " because it does not exist.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        double[][] dArray = new double[1][this.getCols()];
        for (int i = 0; i < this.getCols(); ++i) {
            dArray[0][i] = this.matrix[n][i];
        }
        return new Matrix(dArray);
    }

    public int getRows() {
        return this.matrix.length;
    }

    public int hashCode() {
        long l = 0L;
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                l = (long)((double)l + this.matrix[i][j]);
            }
        }
        return (int)(l % Integer.MAX_VALUE);
    }

    public Matrix inverse() {
        return this.solve(MatrixMath.identity(this.getRows()));
    }

    public boolean isVector() {
        if (this.getRows() == 1) {
            return true;
        }
        return this.getCols() == 1;
    }

    public boolean isZero() {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                if (this.matrix[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public void multiply(double d) {
        for (int i = 0; i < this.getRows(); ++i) {
            int n = 0;
            while (n < this.getCols()) {
                double[] dArray = this.matrix[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
    }

    public void multiply(double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.getRows(); ++i) {
            dArray2[i] = 0.0;
            for (int j = 0; j < this.getCols(); ++j) {
                int n = i;
                dArray2[n] = dArray2[n] + this.matrix[i][j] * dArray[j];
            }
        }
    }

    public void set(double d) {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                this.matrix[i][j] = d;
            }
        }
    }

    public void set(int n, int n2, double d) {
        this.validate(n, n2);
        this.matrix[n][n2] = d;
    }

    public void set(Matrix matrix) {
        double[][] dArray = matrix.getData();
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                this.matrix[i][j] = dArray[i][j];
            }
        }
    }

    public void setMatrix(int n, int n2, int n3, int n4, Matrix matrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    this.matrix[i][j] = matrix.get(i - n, j - n3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MatrixError("Submatrix indices");
        }
    }

    public void setMatrix(int n, int n2, int[] nArray, Matrix matrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    this.matrix[i][nArray[j]] = matrix.get(i - n, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int n, int n2, Matrix matrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    this.matrix[nArray[i]][j] = matrix.get(i, j - n);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, Matrix matrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    this.matrix[nArray[i]][nArray2[j]] = matrix.get(i, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MatrixError("Submatrix indices");
        }
    }

    public int size() {
        return this.matrix[0].length * this.matrix.length;
    }

    public Matrix solve(Matrix matrix) {
        if (this.getRows() == this.getCols()) {
            return new LUDecomposition(this).solve(matrix);
        }
        return new QRDecomposition(this).solve(matrix);
    }

    public double sum() {
        double d = 0.0;
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                d += this.matrix[i][j];
            }
        }
        return d;
    }

    public Double[] toPackedArray() {
        Double[] doubleArray = new Double[this.getRows() * this.getCols()];
        int n = 0;
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                doubleArray[n++] = this.matrix[i][j];
            }
        }
        return doubleArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Matrix: rows=");
        stringBuilder.append(this.getRows());
        stringBuilder.append(",cols=");
        stringBuilder.append(this.getCols());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void validate(int n, int n2) {
        if (n >= this.getRows() || n < 0) {
            String string = "The row:" + n + " is out of range:" + this.getRows();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
        if (n2 >= this.getCols() || n2 < 0) {
            String string = "The col:" + n2 + " is out of range:" + this.getCols();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(string);
            }
            throw new MatrixError(string);
        }
    }
}

