/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

import java.util.List;
import org.encog.engine.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericRange {
    private final double high;
    private final double low;
    private final double mean;
    private final double rms;
    private final double standardDeviation;
    private final int samples;

    public NumericRange(List<Double> list) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (double d5 : list) {
            d = Math.max(d, d5);
            d2 = Math.min(d2, d5);
            d3 += d5;
            d4 += d5 * d5;
        }
        this.samples = list.size();
        this.high = d;
        this.low = d2;
        this.mean = d3 / (double)this.samples;
        this.rms = Math.sqrt(d4 / (double)this.samples);
        double d6 = 0.0;
        for (double d7 : list) {
            d6 += Math.pow(d7 - this.mean, 2.0);
        }
        this.standardDeviation = Math.sqrt(d6 / (double)this.samples);
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public double getMean() {
        return this.mean;
    }

    public double getRms() {
        return this.rms;
    }

    public int getSamples() {
        return this.samples;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Range: ");
        stringBuilder.append(Format.formatDouble(this.low, 5));
        stringBuilder.append(" to ");
        stringBuilder.append(Format.formatDouble(this.high, 5));
        stringBuilder.append(",samples: ");
        stringBuilder.append(Format.formatInteger(this.samples));
        stringBuilder.append(",mean: ");
        stringBuilder.append(Format.formatDouble(this.mean, 5));
        stringBuilder.append(",rms: ");
        stringBuilder.append(Format.formatDouble(this.rms, 5));
        stringBuilder.append(",s.deviation: ");
        stringBuilder.append(Format.formatDouble(this.standardDeviation, 5));
        return stringBuilder.toString();
    }
}

