/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.flat;

import java.io.Serializable;
import java.util.ArrayList;
import org.encog.engine.EncogEngineError;
import org.encog.engine.EngineNeuralNetwork;
import org.encog.engine.data.BasicEngineData;
import org.encog.engine.data.EngineData;
import org.encog.engine.data.EngineIndexableSet;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.engine.network.flat.FlatLayer;
import org.encog.engine.util.EngineArray;
import org.encog.engine.util.ErrorCalculation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatNetwork
implements EngineNeuralNetwork,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_BIAS_ACTIVATION = 1.0;
    public static final double NO_BIAS_ACTIVATION = 0.0;
    private int inputCount;
    private int[] layerCounts;
    private int[] layerContextCount;
    private int[] layerFeedCounts;
    private int[] layerIndex;
    private double[] layerOutput;
    private int outputCount;
    private int[] weightIndex;
    private double[] weights;
    private ActivationFunction[] activationFunctions;
    private int[] contextTargetOffset;
    private int[] contextTargetSize;
    private double[] biasActivation;
    private int beginTraining;
    private int endTraining;
    private boolean isLimited;
    private double connectionLimit;

    public FlatNetwork() {
    }

    public FlatNetwork(FlatLayer[] flatLayerArray) {
        this.init(flatLayerArray);
    }

    public FlatNetwork(int n, int n2, int n3, int n4, boolean bl) {
        FlatLayer[] flatLayerArray;
        double[] dArray = new double[1];
        ActivationFunction activationFunction = bl ? new ActivationTANH() : new ActivationSigmoid();
        dArray[0] = 1.0;
        if (n2 == 0 && n3 == 0) {
            flatLayerArray = new FlatLayer[]{new FlatLayer(activationFunction, n, 1.0, dArray), new FlatLayer(activationFunction, n4, 0.0, dArray)};
        } else if (n2 == 0 || n3 == 0) {
            int n5 = Math.max(n2, n3);
            flatLayerArray = new FlatLayer[]{new FlatLayer(activationFunction, n, 1.0, dArray), new FlatLayer(activationFunction, n5, 1.0, dArray), new FlatLayer(activationFunction, n4, 0.0, dArray)};
        } else {
            flatLayerArray = new FlatLayer[]{new FlatLayer(activationFunction, n, 1.0, dArray), new FlatLayer(activationFunction, n2, 1.0, dArray), new FlatLayer(activationFunction, n3, 1.0, dArray), new FlatLayer(activationFunction, n4, 0.0, dArray)};
        }
        this.isLimited = false;
        this.connectionLimit = 0.0;
        this.init(flatLayerArray);
    }

    public double calculateError(EngineIndexableSet engineIndexableSet) {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        double[] dArray = new double[this.outputCount];
        EngineData engineData = BasicEngineData.createPair(engineIndexableSet.getInputSize(), engineIndexableSet.getIdealSize());
        int n = 0;
        while ((long)n < engineIndexableSet.getRecordCount()) {
            engineIndexableSet.getRecord(n, engineData);
            this.compute(engineData.getInputArray(), dArray);
            errorCalculation.updateError(dArray, engineData.getIdealArray());
            ++n;
        }
        return errorCalculation.calculate();
    }

    public void clearContext() {
        int n = 0;
        for (int i = 0; i < this.layerIndex.length; ++i) {
            int n2;
            boolean bl = this.layerContextCount[i] + this.layerFeedCounts[i] != this.layerCounts[i];
            for (n2 = 0; n2 < this.layerFeedCounts[i]; ++n2) {
                this.layerOutput[n++] = 0.0;
            }
            if (bl) {
                this.layerOutput[n++] = this.biasActivation[i];
            }
            for (n2 = 0; n2 < this.layerContextCount[i]; ++n2) {
                this.layerOutput[n++] = 0.0;
            }
        }
    }

    public FlatNetwork clone() {
        FlatNetwork flatNetwork = new FlatNetwork();
        this.cloneFlatNetwork(flatNetwork);
        return flatNetwork;
    }

    public void cloneFlatNetwork(FlatNetwork flatNetwork) {
        flatNetwork.inputCount = this.inputCount;
        flatNetwork.layerCounts = EngineArray.arrayCopy(this.layerCounts);
        flatNetwork.layerIndex = EngineArray.arrayCopy(this.layerIndex);
        flatNetwork.layerOutput = EngineArray.arrayCopy(this.layerOutput);
        flatNetwork.layerFeedCounts = EngineArray.arrayCopy(this.layerFeedCounts);
        flatNetwork.contextTargetOffset = EngineArray.arrayCopy(this.contextTargetOffset);
        flatNetwork.contextTargetSize = EngineArray.arrayCopy(this.contextTargetSize);
        flatNetwork.layerContextCount = EngineArray.arrayCopy(this.layerContextCount);
        flatNetwork.biasActivation = EngineArray.arrayCopy(this.biasActivation);
        flatNetwork.outputCount = this.outputCount;
        flatNetwork.weightIndex = this.weightIndex;
        flatNetwork.weights = this.weights;
        flatNetwork.activationFunctions = new ActivationFunction[this.activationFunctions.length];
        for (int i = 0; i < flatNetwork.activationFunctions.length; ++i) {
            flatNetwork.activationFunctions[i] = this.activationFunctions[i].clone();
        }
        flatNetwork.beginTraining = this.beginTraining;
        flatNetwork.endTraining = this.endTraining;
    }

    @Override
    public void compute(double[] dArray, double[] dArray2) {
        int n = this.layerOutput.length - this.layerCounts[this.layerCounts.length - 1];
        EngineArray.arrayCopy(dArray, 0, this.layerOutput, n, this.inputCount);
        for (int i = this.layerIndex.length - 1; i > 0; --i) {
            this.computeLayer(i);
        }
        EngineArray.arrayCopy(this.layerOutput, 0, dArray2, 0, this.outputCount);
    }

    protected void computeLayer(int n) {
        int n2;
        int n3 = this.layerIndex[n];
        int n4 = this.layerIndex[n - 1];
        int n5 = this.layerCounts[n];
        int n6 = this.layerFeedCounts[n - 1];
        int n7 = this.weightIndex[n - 1];
        int n8 = n4 + n6;
        int n9 = n3 + n5;
        for (n2 = n4; n2 < n8; ++n2) {
            double d = 0.0;
            for (int i = n3; i < n9; ++i) {
                d += this.weights[n7++] * this.layerOutput[i];
            }
            this.layerOutput[n2] = d;
        }
        this.activationFunctions[n - 1].activationFunction(this.layerOutput, n4, n6);
        n2 = this.contextTargetOffset[n];
        for (int i = 0; i < this.contextTargetSize[n]; ++i) {
            this.layerOutput[n2 + i] = this.layerOutput[n4 + i];
        }
    }

    @Override
    public void decodeNetwork(double[] dArray) {
        if (dArray.length != this.weights.length) {
            throw new EncogEngineError("Incompatable weight sizes, can't assign length=" + dArray.length + " to length=" + dArray.length);
        }
        this.weights = dArray;
    }

    @Override
    public double[] encodeNetwork() {
        return this.weights;
    }

    public int[] getContextTargetOffset() {
        return this.contextTargetOffset;
    }

    public int[] getContextTargetSize() {
        return this.contextTargetSize;
    }

    @Override
    public int getEncodeLength() {
        return this.weights.length;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public int[] getLayerCounts() {
        return this.layerCounts;
    }

    public int[] getLayerFeedCounts() {
        return this.layerFeedCounts;
    }

    public int[] getLayerIndex() {
        return this.layerIndex;
    }

    public double[] getLayerOutput() {
        return this.layerOutput;
    }

    public int getNeuronCount() {
        int n = 0;
        for (int n2 : this.layerCounts) {
            n += n2;
        }
        return n;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    public int[] getWeightIndex() {
        return this.weightIndex;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public Class<?> hasSameActivationFunction() {
        ArrayList arrayList = new ArrayList();
        for (ActivationFunction activationFunction : this.activationFunctions) {
            if (arrayList.contains(activationFunction.getClass())) continue;
            arrayList.add(activationFunction.getClass());
        }
        if (arrayList.size() != 1) {
            return null;
        }
        return (Class)arrayList.get(0);
    }

    public void init(FlatLayer[] flatLayerArray) {
        int n = flatLayerArray.length;
        this.inputCount = flatLayerArray[0].getCount();
        this.outputCount = flatLayerArray[n - 1].getCount();
        this.layerCounts = new int[n];
        this.layerContextCount = new int[n];
        this.weightIndex = new int[n];
        this.layerIndex = new int[n];
        this.activationFunctions = new ActivationFunction[n];
        this.layerFeedCounts = new int[n];
        this.contextTargetOffset = new int[n];
        this.contextTargetSize = new int[n];
        this.biasActivation = new double[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = flatLayerArray.length - 1; i >= 0; --i) {
            FlatLayer flatLayer = flatLayerArray[i];
            FlatLayer flatLayer2 = null;
            if (i > 0) {
                flatLayer2 = flatLayerArray[i - 1];
            }
            this.biasActivation[n2] = flatLayer.getBiasActivation();
            this.layerCounts[n2] = flatLayer.getTotalCount();
            this.layerFeedCounts[n2] = flatLayer.getCount();
            this.layerContextCount[n2] = flatLayer.getContectCount();
            this.activationFunctions[n2] = flatLayer.getActivation();
            n3 += flatLayer.getTotalCount();
            if (flatLayer2 != null) {
                n4 += flatLayer.getCount() * flatLayer2.getTotalCount();
            }
            if (n2 == 0) {
                this.weightIndex[n2] = 0;
                this.layerIndex[n2] = 0;
            } else {
                this.weightIndex[n2] = this.weightIndex[n2 - 1] + this.layerCounts[n2] * this.layerFeedCounts[n2 - 1];
                this.layerIndex[n2] = this.layerIndex[n2 - 1] + this.layerCounts[n2 - 1];
            }
            int n5 = 0;
            for (int j = flatLayerArray.length - 1; j >= 0; --j) {
                if (flatLayerArray[j].getContextFedBy() == flatLayer) {
                    this.contextTargetSize[i] = flatLayerArray[j].getContectCount();
                    this.contextTargetOffset[i] = n5 + flatLayerArray[j].getTotalCount() - flatLayerArray[j].getContectCount();
                }
                n5 += flatLayerArray[j].getTotalCount();
            }
            ++n2;
        }
        this.beginTraining = 0;
        this.endTraining = this.layerCounts.length - 1;
        this.weights = new double[n4];
        this.layerOutput = new double[n3];
        this.clearContext();
    }

    public void randomize() {
        this.randomize(1.0, -1.0);
    }

    public void randomize(double d, double d2) {
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = Math.random() * (d - d2) + d2;
        }
    }

    public int getBeginTraining() {
        return this.beginTraining;
    }

    public void setBeginTraining(int n) {
        this.beginTraining = n;
    }

    public int getEndTraining() {
        return this.endTraining;
    }

    public void setEndTraining(int n) {
        this.endTraining = n;
    }

    public double getConnectionLimit() {
        return this.connectionLimit;
    }

    public void setConnectionLimit(double d) {
        this.connectionLimit = d;
        if (this.connectionLimit > 1.0E-6) {
            this.isLimited = true;
        }
    }

    public boolean isLimited() {
        return this.isLimited;
    }

    public void clearConnectionLimit() {
        this.connectionLimit = 0.0;
        this.isLimited = false;
    }

    public ActivationFunction[] getActivationFunctions() {
        return this.activationFunctions;
    }
}

